"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_DICTIONARY_TYPE = exports.DEFAULT_CONTEXT = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_MINUTE_IN_MS = 60000;
const DEFAULT_DICTIONARY_TYPE = exports.DEFAULT_DICTIONARY_TYPE = {
  logs: [],
  metrics: [],
  traces: [],
  synthetics: [],
  profiling: []
};
const DEFAULT_CONTEXT = exports.DEFAULT_CONTEXT = {
  table: {
    page: 0,
    rowsPerPage: 10,
    sort: {
      field: _constants.DEFAULT_SORT_FIELD,
      direction: _constants.DEFAULT_SORT_DIRECTION
    }
  },
  datasetUserPrivileges: {
    datasetsPrivilages: {},
    canViewIntegrations: true
  },
  authorizedDatasetTypes: [],
  dataStreamStats: [],
  degradedDocStats: [],
  failedDocStats: [],
  totalDocsStats: DEFAULT_DICTIONARY_TYPE,
  filters: {
    inactive: true,
    fullNames: false,
    timeRange: {
      from: 'now-24h',
      to: 'now',
      refresh: {
        pause: true,
        value: ONE_MINUTE_IN_MS
      }
    },
    integrations: [],
    namespaces: [],
    qualities: [],
    types: [_constants.DEFAULT_DATASET_TYPE]
  },
  datasets: [],
  nonAggregatableDatasets: []
};