"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = Overview;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _aggregation_not_supported = require("./aggregation_not_supported");
var _quality_issues = require("./quality_issues");
var _failure_store_warning = require("../../failure_store/failure_store_warning");
var _panel = require("./summary/panel");
var _card = require("./quality_summary_cards/card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverviewHeader = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./header'))), {
  fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 13
    }
  })
});
const Summary = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./summary'))), {
  fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: "",
    isLoading: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: "",
    isLoading: true,
    value: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: "",
    isLoading: true,
    value: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: "",
    isLoading: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: "",
    isLoading: true,
    value: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: "",
    isLoading: true,
    value: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  })))
});
const QualitySummaryCards = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./quality_summary_cards'))), {
  fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    style: {
      height: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_card.Card, {
    title: "",
    isLoading: true,
    kpiValue: "",
    footer: null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_card.Card, {
    title: "",
    isLoading: true,
    kpiValue: "",
    footer: null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })))
});
const DocumentTrends = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./document_trends'))));
function Overview({
  openAlertFlyout
}) {
  const {
    dataStream,
    isNonAggregatable,
    canUserReadFailureStore,
    updateTimeRange,
    loadingState: {
      dataStreamSettingsLoading
    },
    view
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const [lastReloadTime, setLastReloadTime] = (0, _react.useState)(Date.now());
  const [selectedQualityCard, setSelectedQualityCard] = _react.default.useState('degraded');
  const handleTimeChange = (0, _react.useCallback)(refreshProps => {
    updateTimeRange({
      start: refreshProps.from,
      end: refreshProps.to
    });
    setLastReloadTime(Date.now());
  }, [updateTimeRange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isNonAggregatable && /*#__PURE__*/_react.default.createElement(_aggregation_not_supported.AggregationNotSupported, {
    dataStream: dataStream,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 29
    }
  }), /*#__PURE__*/_react.default.createElement(OverviewHeader, {
    handleTimeChange: handleTimeChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), !dataStreamSettingsLoading && !canUserReadFailureStore && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_failure_store_warning.FailureStoreWarning, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  })), view === 'dataQuality' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Summary, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    direction: "row",
    "data-test-subj": "datasetQualityDetailsOverview",
    hasShadow: false,
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(QualitySummaryCards, {
    selectedCard: selectedQualityCard,
    setSelectedCard: setSelectedQualityCard,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(DocumentTrends, {
    lastReloadTime: lastReloadTime,
    openAlertFlyout: openAlertFlyout,
    displayActions: {
      displayCreateRuleButton: selectedQualityCard === 'degraded',
      displayEditFailureStore: selectedQualityCard === 'failed' && view !== 'wired' // Don't allow editing failure store for Wired Streams
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_quality_issues.QualityIssues, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }));
}