"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-views-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/index_pattern_table/spaces_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const noun = _i18n.i18n.translate('indexPatternManagement.indexPatternTable.savedObjectName', {
  defaultMessage: 'data view'
});
const SpacesList = ({
  spacesApi,
  capabilities,
  spaceIds,
  id,
  title,
  refresh
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  function onClose() {
    setShowFlyout(false);
  }
  const LazySpaceList = spacesApi.ui.components.getSpaceList;
  const LazyShareToSpaceFlyout = spacesApi.ui.components.getShareToSpaceFlyout;
  const shareToSpaceFlyoutProps = {
    savedObjectTarget: {
      type: _public.DATA_VIEW_SAVED_OBJECT_TYPE,
      namespaces: spaceIds,
      id,
      title,
      noun
    },
    onUpdate: refresh,
    onClose
  };
  const canAssignSpaces = !capabilities || !!capabilities.savedObjectsManagement.shareIntoSpace;
  const clickProperties = canAssignSpaces ? {
    cursorStyle: 'pointer',
    listOnClick: () => setShowFlyout(true)
  } : {
    cursorStyle: 'not-allowed'
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LazySpaceList, (0, _extends2.default)({
    namespaces: spaceIds,
    displayLimit: 8,
    behaviorContext: "outside-space"
  }, clickProperties, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  })), showFlyout && /*#__PURE__*/_react.default.createElement(LazyShareToSpaceFlyout, (0, _extends2.default)({}, shareToSpaceFlyoutProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 22
    }
  })));
};
exports.SpacesList = SpacesList;