"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceFiltersTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reselect = require("reselect");
var _eui = require("@elastic/eui");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/source_filters_table/source_filters_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class SourceFiltersTable extends _react.Component {
  constructor(_props) {
    super(_props);
    // Source filters do not have unique ids, only the value is stored.
    // To ensure we can create a consistent and expected UX when managing
    // source filters, we are assigning a unique id to each filter on the
    // client side only
    (0, _defineProperty2.default)(this, "clientSideId", 0);
    (0, _defineProperty2.default)(this, "updateFilters", () => {
      const sourceFilters = this.props.indexPattern.sourceFilters;
      const filters = (sourceFilters || []).map(sourceFilter => ({
        ...sourceFilter,
        clientId: ++this.clientSideId
      }));
      this.setState({
        filters
      });
    });
    (0, _defineProperty2.default)(this, "getFilteredFilters", (0, _reselect.createSelector)(state => state.filters, (_state, props) => props.filterFilter, (filters, filterFilter) => {
      if (filterFilter) {
        const filterFilterToLowercase = filterFilter.toLowerCase();
        return filters.filter(filter => filter.value.toLowerCase().includes(filterFilterToLowercase));
      }
      return filters;
    }));
    (0, _defineProperty2.default)(this, "startDeleteFilter", filter => {
      this.setState({
        filterToDelete: filter,
        isDeleteConfirmationModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "hideDeleteConfirmationModal", () => {
      this.setState({
        filterToDelete: undefined,
        isDeleteConfirmationModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "deleteFilter", async () => {
      const {
        indexPattern,
        onAddOrRemoveFilter,
        saveIndexPattern
      } = this.props;
      const {
        filterToDelete,
        filters
      } = this.state;
      indexPattern.sourceFilters = filters.filter(filter => {
        return filter.clientId !== (filterToDelete === null || filterToDelete === void 0 ? void 0 : filterToDelete.clientId);
      });
      this.setState({
        isSaving: true
      });
      await saveIndexPattern(indexPattern);
      if (onAddOrRemoveFilter) {
        onAddOrRemoveFilter();
      }
      this.updateFilters();
      this.setState({
        isSaving: false
      });
      this.hideDeleteConfirmationModal();
    });
    (0, _defineProperty2.default)(this, "onAddFilter", async value => {
      const {
        indexPattern,
        onAddOrRemoveFilter,
        saveIndexPattern
      } = this.props;
      indexPattern.sourceFilters = [...(indexPattern.sourceFilters || []), {
        value
      }];
      this.setState({
        isSaving: true
      });
      await saveIndexPattern(indexPattern);
      if (onAddOrRemoveFilter) {
        onAddOrRemoveFilter();
      }
      this.updateFilters();
      this.setState({
        isSaving: false
      });
    });
    (0, _defineProperty2.default)(this, "saveFilter", async ({
      clientId,
      value
    }) => {
      const {
        indexPattern,
        saveIndexPattern
      } = this.props;
      const {
        filters
      } = this.state;
      indexPattern.sourceFilters = filters.map(filter => {
        if (filter.clientId === clientId) {
          return {
            value,
            clientId
          };
        }
        return filter;
      });
      this.setState({
        isSaving: true
      });
      await saveIndexPattern(indexPattern);
      this.updateFilters();
      this.setState({
        isSaving: false
      });
    });
    this.state = {
      filterToDelete: undefined,
      isDeleteConfirmationModalVisible: false,
      isSaving: false,
      filters: []
    };
  }
  UNSAFE_componentWillMount() {
    this.updateFilters();
  }
  render() {
    const {
      indexPattern,
      fieldWildcardMatcher
    } = this.props;
    const {
      isSaving,
      filterToDelete
    } = this.state;
    const filteredFilters = this.getFilteredFilters(this.state, this.props);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.Header, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.AddFilter, {
      onAddFilter: this.onAddFilter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.Table, {
      isSaving: isSaving,
      indexPattern: indexPattern,
      items: filteredFilters,
      fieldWildcardMatcher: fieldWildcardMatcher,
      deleteFilter: this.startDeleteFilter,
      saveFilter: this.saveFilter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }), filterToDelete && /*#__PURE__*/_react.default.createElement(_components.DeleteFilterConfirmationModal, {
      filterToDeleteValue: filterToDelete.value,
      onCancelConfirmationModal: this.hideDeleteConfirmationModal,
      onDeleteFilter: this.deleteFilter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 11
      }
    }));
  }
}
exports.SourceFiltersTable = SourceFiltersTable;