"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _field_editor_context = require("../field_editor_context");
var _preview = require("../preview");
var _constants = require("./constants");
var _form_schema = require("./form_schema");
var _lib = require("./lib");
var _form_fields = require("./form_fields");
var _field_detail = require("./field_detail");
var _composite_editor = require("./composite_editor");
var _types = require("../preview/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_editor/field_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const changeWarning = _i18n.i18n.translate('indexPatternFieldEditor.editor.form.changeWarning', {
  defaultMessage: 'Changing name or type can break searches and visualizations that rely on this field.'
});
const fieldTypeToComboBoxOption = type => {
  if (type) {
    var _RUNTIME_FIELD_OPTION;
    const label = (_RUNTIME_FIELD_OPTION = _constants.RUNTIME_FIELD_OPTIONS.find(({
      value
    }) => value === type)) === null || _RUNTIME_FIELD_OPTION === void 0 ? void 0 : _RUNTIME_FIELD_OPTION.label;
    return [{
      label: label !== null && label !== void 0 ? label : type,
      value: type
    }];
  }
  return [_constants.RUNTIME_FIELD_OPTIONS[0]];
};
const formDeserializer = field => {
  const fieldType = fieldTypeToComboBoxOption(field.type);
  const format = field.format === null ? undefined : field.format;
  return {
    ...field,
    popularity: typeof field.popularity === 'number' ? String(field.popularity) : field.popularity,
    type: fieldType,
    format,
    __meta__: {
      isCustomLabelVisible: field.customLabel !== undefined,
      isCustomDescriptionVisible: field.customDescription !== undefined,
      isValueVisible: field.script !== undefined,
      isFormatVisible: field.format !== undefined,
      isPopularityVisible: field.popularity !== undefined
    }
  };
};
const formSerializer = field => {
  const {
    __meta__,
    type,
    format,
    popularity,
    ...rest
  } = field;
  return {
    type: type && type[0].value,
    // By passing "null" we are explicitly telling DataView to remove the
    // format if there is one defined for the field.
    format: format === undefined ? null : format,
    // convert from the input string value into a number
    popularity: typeof popularity === 'string' ? Number(popularity) || 0 : popularity,
    ...rest
  };
};
const FieldEditorComponent = ({
  field,
  onChange,
  onFormModifiedChange,
  isDisabled
}) => {
  var _ref, _ref2;
  const {
    fieldTypeToProcess,
    fieldName$,
    subfields$,
    dataView
  } = (0, _field_editor_context.useFieldEditorContext)();
  const {
    params: {
      update: updatePreviewParams
    },
    fieldPreview$
  } = (0, _preview.useFieldPreviewContext)();
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: field,
    schema: _form_schema.schema,
    deserializer: formDeserializer,
    serializer: formSerializer
  });
  const {
    submit,
    isValid: isFormValid,
    isSubmitted,
    getFields,
    isSubmitting
  } = form;
  const nameFieldConfig = (0, _lib.getNameFieldConfig)(dataView, field);
  const [formData] = (0, _shared_imports.useFormData)({
    form
  });
  const isFormModified = (0, _shared_imports.useFormIsModified)({
    form,
    discard: ['__meta__.isCustomLabelVisible', '__meta__.isCustomDescriptionVisible', '__meta__.isValueVisible', '__meta__.isFormatVisible', '__meta__.isPopularityVisible']
  });

  // use observable to sidestep react state
  (0, _react.useEffect)(() => {
    const sub = form.subscribe(({
      data
    }) => {
      if (data.internal.name !== fieldName$.getValue()) {
        fieldName$.next(data.internal.name);
      }
    });
    return () => {
      sub.unsubscribe();
    };
  }, [form, fieldName$]);
  const {
    name: updatedName,
    type: updatedType,
    script: updatedScript,
    format: updatedFormat
  } = formData;
  const {
    name: nameField,
    type: typeField
  } = getFields();
  const nameHasChanged = (_ref = Boolean(field === null || field === void 0 ? void 0 : field.name) && (nameField === null || nameField === void 0 ? void 0 : nameField.isModified)) !== null && _ref !== void 0 ? _ref : false;
  const typeHasChanged = (_ref2 = Boolean(field === null || field === void 0 ? void 0 : field.type) && (typeField === null || typeField === void 0 ? void 0 : typeField.isModified)) !== null && _ref2 !== void 0 ? _ref2 : false;
  const isValueVisible = (0, _lodash.get)(formData, '__meta__.isValueVisible');
  const resetTypes = (0, _react.useCallback)(() => {
    const lastVal = fieldPreview$.getValue();
    // resets the preview history to an empty set
    fieldPreview$.next([]);
    // apply the last preview to get all the types
    fieldPreview$.next(lastVal);
  }, [fieldPreview$]);
  (0, _react.useEffect)(() => {
    const existingCompositeField = !!Object.keys(subfields$.getValue() || {}).length;
    const changes$ = (0, _lib.getFieldPreviewChanges)(fieldPreview$, updatedName);
    const subChanges = changes$.subscribe(previewFields => {
      const fields = subfields$.getValue();
      const modifiedFields = {
        ...fields
      };
      Object.entries(previewFields).forEach(([name, change]) => {
        if (change.changeType === _types.ChangeType.DELETE) {
          delete modifiedFields[name];
        }
        if (change.changeType === _types.ChangeType.UPSERT) {
          modifiedFields[name] = {
            type: change.type
          };
        }
      });
      subfields$.next(modifiedFields);
      // necessary to maintain script code when changing types
      form.updateFieldValues({
        ...form.getFormData()
      });
    });

    // first preview value is skipped for saved fields, need to populate for new fields and rerenders
    if (!existingCompositeField) {
      fieldPreview$.next([]);
    } else if (fieldPreview$.getValue()) {
      fieldPreview$.next(fieldPreview$.getValue());
    }
    return () => {
      subChanges.unsubscribe();
    };
  }, [form, fieldPreview$, subfields$, updatedName]);
  (0, _react.useEffect)(() => {
    if (onChange) {
      onChange({
        isValid: isFormValid,
        isSubmitted,
        isSubmitting,
        submit
      });
    }
  }, [onChange, isFormValid, isSubmitted, isSubmitting, submit]);
  (0, _react.useEffect)(() => {
    updatePreviewParams({
      name: Boolean(updatedName === null || updatedName === void 0 ? void 0 : updatedName.trim()) ? updatedName : null,
      type: updatedType === null || updatedType === void 0 ? void 0 : updatedType[0].value,
      script: isValueVisible === false || Boolean(updatedScript === null || updatedScript === void 0 ? void 0 : updatedScript.source.trim()) === false ? null : {
        source: updatedScript.source
      },
      format: (updatedFormat === null || updatedFormat === void 0 ? void 0 : updatedFormat.id) !== undefined ? updatedFormat : null,
      parentName: field === null || field === void 0 ? void 0 : field.parentName
    });
  }, [updatedName, updatedType, updatedScript, isValueVisible, updatedFormat, updatePreviewParams, field]);
  (0, _react.useEffect)(() => {
    if (onFormModifiedChange) {
      onFormModifiedChange(isFormModified);
    }
  }, [isFormModified, onFormModifiedChange, form]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    className: "indexPatternFieldEditor__form",
    "data-test-subj": "indexPatternFieldEditorForm",
    isInvalid: isSubmitted && isFormValid === false,
    error: form.getErrors(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "name",
    config: nameFieldConfig,
    component: _shared_imports.TextField,
    "data-test-subj": "nameField",
    componentProps: {
      euiFieldProps: {
        disabled: fieldTypeToProcess === 'concrete' || isDisabled,
        'aria-label': _i18n.i18n.translate('indexPatternFieldEditor.editor.form.nameAriaLabel', {
          defaultMessage: 'Name field'
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form_fields.TypeField, {
    isDisabled: fieldTypeToProcess === 'concrete' || isDisabled,
    includeComposite: true,
    path: "type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 11
    }
  }))), (nameHasChanged || typeHasChanged) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    title: changeWarning,
    iconType: "warning",
    size: "s",
    "data-test-subj": "changeWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }), (field === null || field === void 0 ? void 0 : field.parentName) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: false,
    iconType: "info",
    title: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.subFieldParentInfo', {
      defaultMessage: "Field value is defined by ''{parentName}''",
      values: {
        parentName: field === null || field === void 0 ? void 0 : field.parentName
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 11
    }
  })), updatedType && updatedType[0].value !== 'composite' ? /*#__PURE__*/_react.default.createElement(_field_detail.FieldDetail, {
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_composite_editor.CompositeEditor, {
    onReset: resetTypes,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 9
    }
  }));
};
const FieldEditor = exports.FieldEditor = FieldEditorComponent;