"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeViewModeManager = initializeViewModeManager;
var _rxjs = require("rxjs");
var _dashboard_backup_service = require("../services/dashboard_backup_service");
var _get_dashboard_capabilities = require("../utils/get_dashboard_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeViewModeManager({
  incomingEmbeddables,
  isManaged,
  savedObjectId
}) {
  const dashboardBackupService = (0, _dashboard_backup_service.getDashboardBackupService)();
  function getInitialViewMode() {
    if (isManaged || !(0, _get_dashboard_capabilities.getDashboardCapabilities)().showWriteControls) {
      return 'view';
    }
    if (incomingEmbeddables !== null && incomingEmbeddables !== void 0 && incomingEmbeddables.length || !Boolean(savedObjectId) || dashboardBackupService.dashboardHasUnsavedEdits(savedObjectId)) return 'edit';
    return dashboardBackupService.getViewMode();
  }
  const viewMode$ = new _rxjs.BehaviorSubject(getInitialViewMode());
  function setViewMode(viewMode) {
    // block the Dashboard from entering edit mode if this Dashboard is managed.
    if (isManaged && (viewMode === null || viewMode === void 0 ? void 0 : viewMode.toLowerCase()) === 'edit') {
      return;
    }
    viewMode$.next(viewMode);
  }
  return {
    api: {
      viewMode$,
      setViewMode
    }
  };
}