"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNav = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_layout_width = require("../../hooks/use_layout_width");
var _footer = require("../footer");
var _logo = require("./logo");
var _nested_secondary_menu = require("../nested_secondary_menu");
var _popover = require("./popover");
var _primary_menu = require("../primary_menu");
var _secondary_menu = require("../secondary_menu");
var _side_panel = require("./side_panel");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/side_nav/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getWrapperStyles = (theme, isCollapsed) => (0, _react2.css)`
  box-sizing: border-box;
  background-color: ${theme.colors.backgroundBasePlain};
  border-right: ${theme.border.width.thin} solid ${theme.colors.borderBaseSubdued};
  display: flex;
  flex-direction: column;
  gap: ${isCollapsed ? theme.size.s : theme.size.m};
  height: 100%;
  padding-bottom: ${theme.size.base};
  width: ${isCollapsed ? _use_layout_width.COLLAPSED_WIDTH : _use_layout_width.EXPANDED_WIDTH}px;
`;
/**
 * A wrapper component for the side navigation that encapsulates:
 * - the logo,
 * - the primary menu,
 * - the secondary menu used in the popover and in the side panel,
 * - the nested secondary menu used in the "More" menu,
 * - the footer,
 * - the side panel.
 */
const SideNav = ({
  children,
  isCollapsed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const wrapperStyles = (0, _react.useMemo)(() => getWrapperStyles(euiTheme, isCollapsed), [euiTheme, isCollapsed]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _constants.NAVIGATION_ROOT_SELECTOR,
    css: wrapperStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, children);
};
exports.SideNav = SideNav;
SideNav.Logo = _logo.Logo;
SideNav.PrimaryMenu = _primary_menu.PrimaryMenu;
SideNav.Popover = _popover.Popover;
SideNav.SecondaryMenu = _secondary_menu.SecondaryMenu;
SideNav.NestedSecondaryMenu = _nested_secondary_menu.NestedSecondaryMenu;
SideNav.Footer = _footer.Footer;
SideNav.SidePanel = _side_panel.SidePanel;