"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrimaryMenuBase = exports.PrimaryMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _item = require("./item");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _handle_roving_index = require("../../utils/handle_roving_index");
var _update_tab_indices = require("../../utils/update_tab_indices");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/primary_menu/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getPrimaryMenuStyles = (theme, isCollapsed) => (0, _react2.css)`
  align-items: center;
  display: flex;
  flex-direction: column;
  flex: 1;
  gap: ${isCollapsed ? theme.size.xs : theme.size.base};
  min-height: 0;
`;
const PrimaryMenuBase = exports.PrimaryMenuBase = /*#__PURE__*/(0, _react.forwardRef)(({
  children,
  isCollapsed
}, ref) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => getPrimaryMenuStyles(euiTheme, isCollapsed), [euiTheme, isCollapsed]);
  const handleRef = node => {
    if (node) {
      const elements = (0, _get_focusable_elements.getFocusableElements)(node);
      (0, _update_tab_indices.updateTabIndices)(elements);
    }
    if (typeof ref === 'function') ref(node);else if (ref && 'current' in ref) ref.current = node;
  };
  return (
    /*#__PURE__*/
    // The nav itself is not interactive but the children are
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
    _react.default.createElement("nav", {
      "aria-label": _i18n.i18n.translate('core.ui.chrome.sideNavigation.primaryMenuAriaLabel', {
        defaultMessage: 'Main'
      }),
      css: styles,
      id: _constants.PRIMARY_NAVIGATION_ID,
      onKeyDown: _handle_roving_index.handleRovingIndex,
      ref: handleRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    }, children)
  );
});
const PrimaryMenu = exports.PrimaryMenu = Object.assign(PrimaryMenuBase, {
  Item: _item.PrimaryMenuItem
});