"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingIndicator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/loading_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class LoadingIndicator extends _react2.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "loadingCountSubscription", void 0);
    (0, _defineProperty2.default)(this, "state", {
      visible: false
    });
    (0, _defineProperty2.default)(this, "timer", void 0);
    (0, _defineProperty2.default)(this, "increment", 1);
  }
  componentDidMount() {
    this.loadingCountSubscription = this.props.loadingCount$.subscribe(count => {
      if (this.increment > 1) {
        clearTimeout(this.timer);
      }
      this.increment += this.increment;
      this.timer = setTimeout(() => {
        this.setState({
          visible: count > 0
        });
      }, 250);
    });
  }
  componentWillUnmount() {
    if (this.loadingCountSubscription) {
      clearTimeout(this.timer);
      this.loadingCountSubscription.unsubscribe();
      this.loadingCountSubscription = undefined;
    }
  }
  render() {
    const className = (0, _classnames.default)(!this.state.visible && 'kbnLoadingIndicator-hidden');
    const indicatorHiddenCss = !this.state.visible ? (0, _react.css)({
      visibility: 'hidden',
      animationPlayState: 'paused'
    }) : undefined;
    const testSubj = this.state.visible ? 'globalLoadingIndicator' : 'globalLoadingIndicator-hidden';
    const ariaLabel = _i18n.i18n.translate('core.ui.loadingIndicatorAriaLabel', {
      defaultMessage: 'Loading content'
    });
    const logoImage = this.props.customLogo ? /*#__PURE__*/_react2.default.createElement(_eui.EuiImage, {
      src: this.props.customLogo,
      "data-test-subj": testSubj,
      size: 24,
      alt: "logo",
      "aria-label": _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.customLogoAriaLabel', {
        defaultMessage: 'User logo'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: 'logoElastic',
      size: "l",
      "data-test-subj": testSubj,
      "aria-label": _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.logoAriaLabel', {
        defaultMessage: 'Elastic Logo'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    });
    const logo = this.state.visible ? /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      "data-test-subj": testSubj,
      "aria-hidden": false,
      "aria-label": ariaLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    }) : logoImage;
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_react.Global, {
      styles: {
        '.euiHeaderSectionItem .euiButtonEmpty__text': {
          // stop global header buttons from jumping during loading state
          display: 'flex'
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }), !this.props.showAsBar ? logo : /*#__PURE__*/_react2.default.createElement(_eui.EuiProgress, {
      className: className,
      css: indicatorHiddenCss,
      "data-test-subj": testSubj,
      max: this.props.maxAmount,
      value: this.props.valueAmount,
      position: "fixed",
      color: "accent",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    }));
  }
}
exports.LoadingIndicator = LoadingIndicator;
(0, _defineProperty2.default)(LoadingIndicator, "defaultProps", {
  showAsBar: false
});