"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataControlEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _std = require("@kbn/std");
var _controlsConstants = require("@kbn/controls-constants");
var _kibana_services = require("../../services/kibana_services");
var _control_factory_registry = require("../../control_factory_registry");
var _data_control_constants = require("./data_control_constants");
var _data_control_editor_utils = require("./data_control_editor_utils");
var _editor_constants = require("./editor_constants");
var _types = require("./types");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/data_control_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldPicker = (0, _public.withSuspense)(_public.LazyFieldPicker, null);
const DataViewPicker = (0, _public.withSuspense)(_public.LazyDataViewPicker, null);
const CompatibleControlTypesComponent = ({
  fieldRegistry,
  selectedFieldName,
  selectedControlType,
  setSelectedControlType
}) => {
  const [dataControlFactories, setDataControlFactories] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    let cancelled = false;
    (0, _std.asyncMap)((0, _control_factory_registry.getAllControlTypes)(), async controlType => (0, _control_factory_registry.getControlFactory)(controlType)).then(controlFactories => {
      if (!cancelled) {
        setDataControlFactories(controlFactories.filter(factory => (0, _types.isDataControlFactory)(factory)).sort(({
          order: orderA = 0,
          getDisplayName: getDisplayNameA
        }, {
          order: orderB = 0,
          getDisplayName: getDisplayNameB
        }) => {
          const orderComparison = orderB - orderA; // sort descending by order
          return orderComparison === 0 ? getDisplayNameA().localeCompare(getDisplayNameB()) // if equal order, compare display names
          : orderComparison;
        }));
      }
    }).catch(() => {
      if (!cancelled) setDataControlFactories([]);
    });
    return () => {
      cancelled = true;
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: dataControlFactories === undefined,
    width: "100px",
    height: "100px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenu, {
    "data-test-subj": `controlTypeMenu`,
    "aria-label": 'type',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, (dataControlFactories !== null && dataControlFactories !== void 0 ? dataControlFactories : []).map(factory => {
    var _fieldRegistry$select;
    const disabled = fieldRegistry && selectedFieldName ? !((_fieldRegistry$select = fieldRegistry[selectedFieldName]) !== null && _fieldRegistry$select !== void 0 && _fieldRegistry$select.compatibleControlTypes.includes(factory.type)) : true;
    const keyPadMenuItem = /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
      key: factory.type,
      id: `create__${factory.type}`,
      "aria-label": factory.getDisplayName(),
      "data-test-subj": `create__${factory.type}`,
      isSelected: factory.type === selectedControlType,
      disabled: disabled,
      onClick: () => setSelectedControlType(factory.type),
      label: factory.getDisplayName(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: factory.getIconType(),
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 15
      }
    }));
    return disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      key: `disabled__${factory.type}`,
      content: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getControlTypeErrorMessage({
        fieldSelected: Boolean(selectedFieldName),
        controlType: factory.type
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    }, keyPadMenuItem) : keyPadMenuItem;
  })));
};
const DataControlEditor = ({
  initialState,
  controlId,
  controlType,
  initialDefaultPanelTitle,
  onSave,
  onCancel,
  controlGroupApi,
  ariaLabelledBy
}) => {
  var _ref, _initialState$title, _selectedDataView$get, _editorState$width, _editorState$grow, _editorState$title, _editorState$title2, _editorState$title3;
  const [editorState, setEditorState] = (0, _react.useState)(initialState);
  const [defaultPanelTitle, setDefaultPanelTitle] = (0, _react.useState)((_ref = initialDefaultPanelTitle !== null && initialDefaultPanelTitle !== void 0 ? initialDefaultPanelTitle : initialState.fieldName) !== null && _ref !== void 0 ? _ref : '');
  const [panelTitle, setPanelTitle] = (0, _react.useState)((_initialState$title = initialState.title) !== null && _initialState$title !== void 0 ? _initialState$title : defaultPanelTitle);
  const [selectedControlType, setSelectedControlType] = (0, _react.useState)(controlType);
  const [controlOptionsValid, setControlOptionsValid] = (0, _react.useState)(true);
  const editorConfig = (0, _react.useMemo)(() => controlGroupApi.getEditorConfig(), [controlGroupApi]);
  const {
    loading: dataViewListLoading,
    value: dataViewListItems = [],
    error: dataViewListError
  } = (0, _useAsync.default)(async () => {
    return _kibana_services.dataViewsService.getIdsWithTitle();
  });
  const {
    loading: dataViewLoading,
    value: {
      selectedDataView,
      fieldRegistry
    } = {
      selectedDataView: undefined,
      fieldRegistry: undefined
    },
    error: fieldListError
  } = (0, _useAsync.default)(async () => {
    if (!editorState.dataViewId) {
      return;
    }
    const dataView = await _kibana_services.dataViewsService.get(editorState.dataViewId);
    const registry = await (0, _data_control_editor_utils.getDataControlFieldRegistry)(dataView);
    return {
      selectedDataView: dataView,
      fieldRegistry: registry
    };
  }, [editorState.dataViewId]);
  const [controlFactory, setControlFactory] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    if (!selectedControlType) {
      setControlFactory(undefined);
      return;
    }
    let cancelled = false;
    (0, _control_factory_registry.getControlFactory)(selectedControlType).then(nextControlFactory => {
      if (!cancelled) {
        setControlFactory(nextControlFactory);
      }
    }).catch(() => {
      if (!cancelled) {
        setControlFactory(undefined);
      }
    });
    return () => {
      cancelled = true;
    };
  }, [selectedControlType]);
  const CustomSettingsComponent = (0, _react.useMemo)(() => {
    if (!controlFactory || !editorState.fieldName || !fieldRegistry) return;
    const CustomSettings = controlFactory.CustomOptionsComponent;
    if (!CustomSettings) return;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "control-editor-custom-settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(CustomSettings, {
      initialState: initialState,
      field: fieldRegistry[editorState.fieldName].field,
      updateState: newState => setEditorState({
        ...editorState,
        ...newState
      }),
      setControlEditorValid: setControlOptionsValid,
      controlGroupApi: controlGroupApi,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 9
      }
    }));
  }, [fieldRegistry, controlFactory, initialState, editorState, controlGroupApi]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: ariaLabelledBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 11
    }
  }, !controlId // if no ID, then we are creating a new control
  ? _data_control_constants.DataControlEditorStrings.manageControl.getFlyoutCreateTitle() : _data_control_constants.DataControlEditorStrings.manageControl.getFlyoutEditTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "control-editor-flyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 9
    }
  }, !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideDataViewSelector) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "control-editor-data-view-picker",
    label: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getDataViewTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 13
    }
  }, dataViewListError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    iconType: "error",
    title: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getDataViewListErrorTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 19
    }
  }, dataViewListError.message)) : /*#__PURE__*/_react.default.createElement(DataViewPicker, {
    dataViews: dataViewListItems,
    selectedDataViewId: editorState.dataViewId,
    onChangeDataViewId: newDataViewId => {
      setEditorState({
        ...editorState,
        dataViewId: newDataViewId
      });
      setSelectedControlType(undefined);
    },
    trigger: {
      label: (_selectedDataView$get = selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.getName()) !== null && _selectedDataView$get !== void 0 ? _selectedDataView$get : _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getSelectDataViewMessage()
    },
    selectableProps: {
      isLoading: dataViewListLoading
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getFieldTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 11
    }
  }, fieldListError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    iconType: "error",
    title: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getFieldListErrorTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 17
    }
  }, fieldListError.message)) : /*#__PURE__*/_react.default.createElement(FieldPicker, {
    filterPredicate: field => {
      var _editorConfig$fieldFi, _editorConfig$fieldFi2;
      const customPredicate = (_editorConfig$fieldFi = editorConfig === null || editorConfig === void 0 ? void 0 : (_editorConfig$fieldFi2 = editorConfig.fieldFilterPredicate) === null || _editorConfig$fieldFi2 === void 0 ? void 0 : _editorConfig$fieldFi2.call(editorConfig, field)) !== null && _editorConfig$fieldFi !== void 0 ? _editorConfig$fieldFi : true;
      return Boolean(fieldRegistry === null || fieldRegistry === void 0 ? void 0 : fieldRegistry[field.name]) && customPredicate;
    },
    selectedFieldName: editorState.fieldName,
    dataView: selectedDataView,
    onSelectField: field => {
      var _fieldRegistry$field$, _fieldRegistry$field$2, _field$displayName;
      setEditorState({
        ...editorState,
        fieldName: field.name
      });

      /**
       * make sure that the new field is compatible with the selected control type and, if it's not,
       * reset the selected control type to the **first** compatible control type
       */
      const newCompatibleControlTypes = (_fieldRegistry$field$ = fieldRegistry === null || fieldRegistry === void 0 ? void 0 : (_fieldRegistry$field$2 = fieldRegistry[field.name]) === null || _fieldRegistry$field$2 === void 0 ? void 0 : _fieldRegistry$field$2.compatibleControlTypes) !== null && _fieldRegistry$field$ !== void 0 ? _fieldRegistry$field$ : [];
      if (!selectedControlType || !newCompatibleControlTypes.includes(selectedControlType)) {
        setSelectedControlType(newCompatibleControlTypes[0]);
      }

      /**
       * set the control title (i.e. the one set by the user) + default title (i.e. the field display name)
       */
      const newDefaultTitle = (_field$displayName = field.displayName) !== null && _field$displayName !== void 0 ? _field$displayName : field.name;
      setDefaultPanelTitle(newDefaultTitle);
      const currentTitle = editorState.title;
      if (!currentTitle || currentTitle === newDefaultTitle) {
        setPanelTitle(newDefaultTitle);
      }
      setControlOptionsValid(true); // reset options state
    },
    selectableProps: {
      isLoading: dataViewListLoading || dataViewLoading
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getControlTypeTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CompatibleControlTypesComponent, {
    fieldRegistry: fieldRegistry,
    selectedFieldName: editorState.fieldName,
    selectedControlType: selectedControlType,
    setSelectedControlType: setSelectedControlType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _data_control_constants.DataControlEditorStrings.manageControl.displaySettings.getTitleInputTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "control-editor-title-input",
    placeholder: defaultPanelTitle,
    value: panelTitle,
    compressed: true,
    onChange: e => {
      var _e$target$value;
      setPanelTitle((_e$target$value = e.target.value) !== null && _e$target$value !== void 0 ? _e$target$value : '');
      setEditorState({
        ...editorState,
        title: e.target.value === '' ? undefined : e.target.value
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 13
    }
  })), !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideWidthSettings) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "control-editor-width-settings",
    label: _data_control_constants.DataControlEditorStrings.manageControl.displaySettings.getWidthInputTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    legend: _data_control_constants.DataControlEditorStrings.management.controlWidth.getWidthSwitchLegend(),
    options: _editor_constants.CONTROL_WIDTH_OPTIONS,
    idSelected: (_editorState$width = editorState.width) !== null && _editorState$width !== void 0 ? _editorState$width : _controlsConstants.DEFAULT_CONTROL_WIDTH,
    onChange: newWidth => setEditorState({
      ...editorState,
      width: newWidth
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _data_control_constants.DataControlEditorStrings.manageControl.displaySettings.getGrowSwitchTitle(),
    color: "primary",
    checked: (_editorState$grow = editorState.grow) !== null && _editorState$grow !== void 0 ? _editorState$grow : _controlsConstants.DEFAULT_CONTROL_GROW,
    onChange: () => setEditorState({
      ...editorState,
      grow: !editorState.grow
    }),
    "data-test-subj": "control-editor-grow-switch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 17
    }
  }))), !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideAdditionalSettings) && CustomSettingsComponent)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `cancel-${(_editorState$title = editorState.title) !== null && _editorState$title !== void 0 ? _editorState$title : editorState.fieldName}`,
    "data-test-subj": "control-editor-cancel",
    onClick: () => {
      onCancel(editorState);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 424,
      columnNumber: 13
    }
  }, _data_control_constants.DataControlEditorStrings.manageControl.getCancelTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 13
    }
  }, controlId && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": `delete-${(_editorState$title2 = editorState.title) !== null && _editorState$title2 !== void 0 ? _editorState$title2 : editorState.fieldName}`,
    iconType: "trash",
    color: "danger",
    onClick: () => {
      (0, _common.confirmDeleteControl)().then(confirmed => {
        if (confirmed) {
          onCancel(initialState); // don't want to show "lost changes" warning
          controlGroupApi.removePanel(controlId);
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 17
    }
  }, _data_control_constants.DataControlEditorStrings.manageControl.getDeleteButtonTitle()), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": `save-${(_editorState$title3 = editorState.title) !== null && _editorState$title3 !== void 0 ? _editorState$title3 : editorState.fieldName}`,
    "data-test-subj": "control-editor-save",
    fill: true,
    color: "primary",
    disabled: !(controlOptionsValid && Boolean(editorState.fieldName) && Boolean(selectedDataView) && Boolean(selectedControlType)),
    onClick: () => {
      onSave(editorState, selectedControlType);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 453,
      columnNumber: 15
    }
  }, _data_control_constants.DataControlEditorStrings.manageControl.getSaveChangesTitle()))))));
};
exports.DataControlEditor = DataControlEditor;