"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryMetadataSchema = exports.StreamingResponseSchema = exports.StreamActionParamsSchema = exports.SecretsSchema = exports.RunActionResponseSchema = exports.RunActionParamsSchema = exports.InvokeAIActionResponseSchema = exports.InvokeAIActionParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConfigSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TelemetryMetadataSchema = exports.TelemetryMetadataSchema = _zod.z.object({
  pluginId: _zod.z.string().optional(),
  aggregateBy: _zod.z.string().optional()
}).strict();

// Connector schema
const ConfigSchema = exports.ConfigSchema = _zod.z.union([_zod.z.object({
  apiProvider: _zod.z.enum([_constants.OpenAiProviderType.AzureAi]),
  apiUrl: _zod.z.string(),
  headers: _zod.z.record(_zod.z.string(), _zod.z.string()).optional(),
  contextWindowLength: _zod.z.coerce.number().optional(),
  temperature: _zod.z.coerce.number().optional()
}).strict(), _zod.z.object({
  apiProvider: _zod.z.enum([_constants.OpenAiProviderType.OpenAi]),
  apiUrl: _zod.z.string(),
  organizationId: _zod.z.string().optional(),
  projectId: _zod.z.string().optional(),
  defaultModel: _zod.z.string().default(_constants.DEFAULT_MODEL),
  headers: _zod.z.record(_zod.z.string(), _zod.z.string()).optional(),
  contextWindowLength: _zod.z.coerce.number().optional(),
  temperature: _zod.z.coerce.number().optional()
}).strict(), _zod.z.object({
  apiProvider: _zod.z.enum([_constants.OpenAiProviderType.Other]),
  apiUrl: _zod.z.string(),
  defaultModel: _zod.z.string(),
  verificationMode: _zod.z.enum(['full', 'certificate', 'none']).default('full').optional(),
  headers: _zod.z.record(_zod.z.string(), _zod.z.string()).optional(),
  contextWindowLength: _zod.z.coerce.number().optional(),
  temperature: _zod.z.coerce.number().optional(),
  enableNativeFunctionCalling: _zod.z.boolean().optional()
}).strict()]);
const SecretsSchema = exports.SecretsSchema = _zod.z.union([_zod.z.object({
  apiKey: _zod.z.string()
}).strict(), _zod.z.object({
  apiKey: _zod.z.string().min(1).optional(),
  certificateData: _zod.z.string().min(1).optional(),
  privateKeyData: _zod.z.string().min(1).optional(),
  caData: _zod.z.string().min(1).optional()
}).strict()]);

// Run action schema
const RunActionParamsSchema = exports.RunActionParamsSchema = _zod.z.object({
  body: _zod.z.string(),
  // abort signal from client
  signal: _zod.z.any().optional(),
  timeout: _zod.z.coerce.number().optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const AIMessage = _zod.z.object({
  role: _zod.z.string(),
  content: _zod.z.string(),
  name: _zod.z.string().optional(),
  function_call: _zod.z.object({
    arguments: _zod.z.string(),
    name: _zod.z.string()
  }).strict().optional(),
  tool_calls: _zod.z.array(_zod.z.object({
    id: _zod.z.string(),
    function: _zod.z.object({
      arguments: _zod.z.string(),
      name: _zod.z.string()
    }).strict(),
    type: _zod.z.string()
  }).strict()).optional(),
  tool_call_id: _zod.z.string().optional()
}).strict();

// Run action schema
const InvokeAIActionParamsSchema = exports.InvokeAIActionParamsSchema = _zod.z.object({
  messages: _zod.z.array(AIMessage),
  model: _zod.z.string().optional(),
  tools: _zod.z.array(_zod.z.object({
    type: _zod.z.literal('function'),
    function: _zod.z.object({
      description: _zod.z.string().optional(),
      name: _zod.z.string(),
      parameters: _zod.z.object({}).passthrough(),
      strict: _zod.z.boolean().optional()
    }).passthrough()
  })
  // Not sure if this will include other properties, we should pass them if it does
  .passthrough()).optional(),
  tool_choice: _zod.z.union([_zod.z.literal('none'), _zod.z.literal('auto'), _zod.z.literal('required'), _zod.z.object({
    type: _zod.z.literal('function'),
    function: _zod.z.object({
      name: _zod.z.string()
    }).passthrough()
  })]).optional(),
  // Deprecated in favor of tools
  functions: _zod.z.array(_zod.z.object({
    name: _zod.z.string(),
    description: _zod.z.string(),
    parameters: _zod.z.object({
      type: _zod.z.string(),
      properties: _zod.z.object({}).passthrough(),
      additionalProperties: _zod.z.boolean(),
      $schema: _zod.z.string()
    }).passthrough()
  })
  // Not sure if this will include other properties, we should pass them if it does
  .passthrough()).optional(),
  // Deprecated in favor of tool_choice
  function_call: _zod.z.union([_zod.z.literal('none'), _zod.z.literal('auto'), _zod.z.object({
    name: _zod.z.string()
  })]).optional(),
  n: _zod.z.coerce.number().optional(),
  stop: _zod.z.union([_zod.z.string(), _zod.z.array(_zod.z.string())]).nullish(),
  temperature: _zod.z.coerce.number().optional(),
  response_format: _zod.z.any().optional(),
  // abort signal from client
  signal: _zod.z.any().optional(),
  timeout: _zod.z.coerce.number().optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const InvokeAIActionResponseSchema = exports.InvokeAIActionResponseSchema = _zod.z.object({
  message: _zod.z.string(),
  usage: _zod.z.object({
    prompt_tokens: _zod.z.coerce.number(),
    completion_tokens: _zod.z.coerce.number(),
    total_tokens: _zod.z.coerce.number()
  })
});

// Execute action schema
const StreamActionParamsSchema = exports.StreamActionParamsSchema = _zod.z.object({
  body: _zod.z.string(),
  stream: _zod.z.boolean().default(false),
  // abort signal from client
  signal: _zod.z.any().optional(),
  timeout: _zod.z.coerce.number().optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const StreamingResponseSchema = exports.StreamingResponseSchema = _zod.z.any();
const RunActionResponseSchema = exports.RunActionResponseSchema = _zod.z.object({
  id: _zod.z.string().optional(),
  object: _zod.z.string().optional(),
  created: _zod.z.coerce.number().optional(),
  model: _zod.z.string().optional(),
  usage: _zod.z.object({
    prompt_tokens: _zod.z.coerce.number(),
    completion_tokens: _zod.z.coerce.number(),
    total_tokens: _zod.z.coerce.number()
  }),
  choices: _zod.z.array(_zod.z.object({
    message: _zod.z.object({
      role: _zod.z.string(),
      // nullable because message can contain function calls instead of final response when used with RAG
      content: _zod.z.string().nullish()
    }),
    finish_reason: _zod.z.string().optional(),
    index: _zod.z.coerce.number().optional()
  }))
});

// Run action schema
const DashboardActionParamsSchema = exports.DashboardActionParamsSchema = _zod.z.object({
  dashboardId: _zod.z.string()
}).strict();
const DashboardActionResponseSchema = exports.DashboardActionResponseSchema = _zod.z.object({
  available: _zod.z.boolean()
});