"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstallationStats = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _services = require("@kbn/fleet-plugin/server/services");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEnabledInputStreamVars = packagePolicy => {
  const enabledInput = packagePolicy.inputs.find(input => input.enabled);
  return enabledInput === null || enabledInput === void 0 ? void 0 : enabledInput.streams[0].vars;
};
const getEnabledIsSetupAutomatic = packagePolicy => {
  var _enabledInput$config, _enabledInput$config$;
  const cloudbeatConfig = {
    'cloudbeat/cis_aws': 'cloud_formation_template_url',
    'cloudbeat/vuln_mgmt_aws': 'cloud_formation_template_url',
    'cloudbeat/cis_gcp': 'cloud_shell_url',
    'cloudbeat/cis_azure': 'arm_template_url'
  };
  const enabledInput = packagePolicy.inputs.find(input => input.enabled);
  if (!enabledInput) return false;
  const configKey = cloudbeatConfig[enabledInput.type];
  return !!configKey && !!((_enabledInput$config = enabledInput.config) !== null && _enabledInput$config !== void 0 && (_enabledInput$config$ = _enabledInput$config[configKey]) !== null && _enabledInput$config$ !== void 0 && _enabledInput$config$.value);
};
const getSetupAccessOption = packagePolicy => {
  const inputStreamVars = getEnabledInputStreamVars(packagePolicy);
  if (!inputStreamVars) return null;
  const credentialMappings = {
    'gcp.credentials.file': 'credentials file',
    'gcp.credentials.json': 'credentials json',
    shared_credential_file: 'credentials file',
    role_arn: 'role'
  };
  for (const [key, config] of Object.entries(inputStreamVars)) {
    if (config !== null && config !== void 0 && config.value && credentialMappings[key]) {
      return credentialMappings[key];
    }
  }
  if (inputStreamVars.session_token) return 'temporary access';
  if (inputStreamVars.access_key && inputStreamVars.secret_access_key) return 'direct access';
  return null;
};
const getAccountTypeField = packagePolicy => {
  var _packagePolicy$vars, _packagePolicy$vars$p, _packagePolicy$vars2, _packagePolicy$vars2$, _inputStreamVars;
  if (((_packagePolicy$vars = packagePolicy.vars) === null || _packagePolicy$vars === void 0 ? void 0 : (_packagePolicy$vars$p = _packagePolicy$vars.posture) === null || _packagePolicy$vars$p === void 0 ? void 0 : _packagePolicy$vars$p.value) !== 'cspm') return;
  const inputStreamVars = getEnabledInputStreamVars(packagePolicy);
  const cloudProvider = (_packagePolicy$vars2 = packagePolicy.vars) === null || _packagePolicy$vars2 === void 0 ? void 0 : (_packagePolicy$vars2$ = _packagePolicy$vars2.deployment) === null || _packagePolicy$vars2$ === void 0 ? void 0 : _packagePolicy$vars2$.value;
  const accountType = inputStreamVars === null || inputStreamVars === void 0 ? void 0 : (_inputStreamVars = inputStreamVars[`${cloudProvider}.account_type`]) === null || _inputStreamVars === void 0 ? void 0 : _inputStreamVars.value;

  // If the account_type field is not present, we can assume that the cspm integrations is a single accounts,
  // as this field did not exist before organization accounts were introduced.
  if (!accountType) return 'single-account';
  return accountType;
};
const getInstalledPackagePolicies = (packagePolicies, agentPolicies) => {
  const installationStats = packagePolicies.flatMap(packagePolicy => packagePolicy.policy_ids.map(agentPolicyId => {
    var _packagePolicy$vars3, _packagePolicy$vars3$, _packagePolicy$vars4, _packagePolicy$vars4$, _packagePolicy$packag;
    const matchedAgentPolicy = agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.find(agentPolicy => (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id) === agentPolicyId);
    const agentCounts = (matchedAgentPolicy === null || matchedAgentPolicy === void 0 ? void 0 : matchedAgentPolicy.agents) || 0;
    const isAgentless = !!(matchedAgentPolicy !== null && matchedAgentPolicy !== void 0 && matchedAgentPolicy.supports_agentless);
    const isSetupAutomatic = getEnabledIsSetupAutomatic(packagePolicy);
    return {
      package_policy_id: packagePolicy.id,
      feature: (_packagePolicy$vars3 = packagePolicy.vars) === null || _packagePolicy$vars3 === void 0 ? void 0 : (_packagePolicy$vars3$ = _packagePolicy$vars3.posture) === null || _packagePolicy$vars3$ === void 0 ? void 0 : _packagePolicy$vars3$.value,
      deployment_mode: (_packagePolicy$vars4 = packagePolicy.vars) === null || _packagePolicy$vars4 === void 0 ? void 0 : (_packagePolicy$vars4$ = _packagePolicy$vars4.deployment) === null || _packagePolicy$vars4$ === void 0 ? void 0 : _packagePolicy$vars4$.value,
      package_version: (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.version,
      created_at: packagePolicy.created_at,
      agent_policy_id: agentPolicyId,
      agent_count: agentCounts,
      is_agentless: isAgentless,
      account_type: getAccountTypeField(packagePolicy),
      is_setup_automatic: isSetupAutomatic,
      setup_access_option: isSetupAutomatic ? null : getSetupAccessOption(packagePolicy),
      supports_cloud_connector: !!(packagePolicy !== null && packagePolicy !== void 0 && packagePolicy.supports_cloud_connector),
      cloud_connector_id: packagePolicy.cloud_connector_id || null
    };
  }));
  return installationStats;
};
const getInstallationStats = async (esClient, soClient, coreServices, logger) => {
  const [, cspServerPluginStartDeps] = await coreServices;
  const cspContext = {
    logger,
    esClient,
    soClient,
    agentPolicyService: cspServerPluginStartDeps.fleet.agentPolicyService,
    packagePolicyService: cspServerPluginStartDeps.fleet.packagePolicyService,
    isPluginInitialized
  };
  const packagePolicies = await cspContext.packagePolicyService.list(soClient, {
    perPage: _common.SO_SEARCH_LIMIT,
    kuery: `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:"${_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME}"`
  });
  if (!packagePolicies) return [];
  const agentPolicies = await _services.agentPolicyService.list(soClient, {
    perPage: _common.SO_SEARCH_LIMIT,
    kuery: '',
    esClient,
    withAgentCount: true
  });
  const installationStats = getInstalledPackagePolicies(packagePolicies.items, (agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.items) || []);
  return installationStats;
};
exports.getInstallationStats = getInstallationStats;
const isPluginInitialized = () => {
  return true;
};