"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyTemplateSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/fleet_extensions/policy_template_selectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getPolicyTemplateLabel = policyTemplate => {
  if (policyTemplate === _constants.VULN_MGMT_POLICY_TEMPLATE) {
    return _constants.CNVM_POLICY_TEMPLATE.toUpperCase();
  }
  return policyTemplate.toUpperCase();
};
const PolicyTemplateSelector = ({
  policy,
  selectedTemplate,
  setPolicyTemplate,
  disabled
}) => {
  const policyTemplates = new Set(policy.inputs.map(input => input.policy_template));
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.selectIntegrationTypeTitle",
    defaultMessage: "Select the type of security posture management integration you want to configure",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.RadioGroup, {
    options: Array.from(policyTemplates, v => ({
      id: v,
      label: getPolicyTemplateLabel(v),
      testId: `policy-template-radio-button-${v}`
    })),
    idSelected: selectedTemplate,
    onChange: id => setPolicyTemplate(id),
    disabled: disabled,
    name: "policyTemplate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
};
exports.PolicyTemplateSelector = PolicyTemplateSelector;