"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultObservableTypesModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../create/translations");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/observables/default_observable_types_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HASH_FIELDS = ['cdhash', 'md5', 'sha1', 'sha256', 'sha384', 'sha512', 'ssdeep', 'tlsh'];

// https://www.elastic.co/docs/reference/ecs/ecs-hash
// TODO - support 'email.attachments.file'
const HASH_PARENTS = ['dll', 'file', 'process'];
const defaultObservableTypes = [{
  label: i18n.AGENT_ID,
  value: ['agent.id']
}, {
  label: i18n.HOST_NAME,
  value: ['host.name']
}, {
  label: i18n.IP,
  value: ['source.ip', 'destination.ip']
}, {
  label: i18n.FILE_PATH,
  value: ['file.path']
}, {
  label: i18n.DOMAIN,
  value: ['dns.question.name']
}, {
  label: i18n.FILE_HASH,
  value: HASH_PARENTS.map(parent => HASH_FIELDS.map(field => `${parent}.hash.${field}`)).flat()
}];

/**
 * Renders a gear icon that opens a modal with the default observable types.
 */
const DefaultObservableTypesModal = () => {
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsModalOpen(isOpen => !isOpen);
  const onCancel = (0, _react.useCallback)(() => setIsModalOpen(false), []);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const modal = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    css: {
      width: '600px'
    },
    id: modalTitleId,
    onClose: onCancel,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    size: "s",
    "data-test-subj": "default-observable-types-modal-header-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, _translations.EXTRACT_OBSERVABLES_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    "data-test-subj": "default-observable-types-modal-body",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, i18n.DEFAULT_OBSERVABLE_TYPES_MODAL_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, defaultObservableTypes.map(observableType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 19
    }
  }, observableType.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 17
    }
  }, observableType.value.map(value => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 23
    }
  }, value))))))))), [onCancel, modalTitleId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "gear",
    onClick: onButtonClick,
    size: "s",
    color: "text",
    "data-test-subj": "default-observable-types-modal-button",
    "aria-label": i18n.DEFAULT_OBSERVABLE_TYPES_MODAL_BUTTON_ARIA_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }), isModalOpen && modal);
};
exports.DefaultObservableTypesModal = DefaultObservableTypesModal;
DefaultObservableTypesModal.displayName = 'DefaultObservableTypesModal';