"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCelConfigFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _state = require("../../state");
var i18n = _interopRequireWildcard(require("./translations"));
var _upload_spec_step = require("./steps/upload_spec_step");
var _confirm_settings_step = require("./steps/confirm_settings_step");
var _footer = require("./footer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/flyout/cel_configuration/create_cel_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const flyoutBodyCss = (0, _react2.css)`
  height: 100%;
  .euiFlyoutBody__overflowContent {
    height: 100%;
    padding: 80;
  }
`;
const CreateCelConfigFlyout = exports.CreateCelConfigFlyout = /*#__PURE__*/_react.default.memo(({
  integrationSettings,
  isFlyoutGenerating,
  connector
}) => {
  const {
    setShowCelCreateFlyout,
    setCelInputResult,
    setIntegrationSettings
  } = (0, _state.useActions)();
  const [suggestedPaths, setSuggestedPaths] = (0, _react.useState)([]);
  const isAnalyzeApiGenerationComplete = suggestedPaths.length > 0;
  const [completedCelGeneration, setCompletedCelGeneration] = (0, _react.useState)(false);
  const [celConfig, setCelConfig] = (0, _react.useState)(undefined);
  const [showValidation, setShowValidation] = (0, _react.useState)(false);
  const [needsGeneration, setNeedsGeneration] = (0, _react.useState)(true);
  const [isValid, setIsValid] = (0, _react.useState)(false);
  const [isUploadStepExpanded, setIsUploadStepExpanded] = (0, _react.useState)(true);
  const [isConfirmStepExpanded, setIsConfirmStepExpanded] = (0, _react.useState)(false);
  const onSaveConfig = (0, _react.useCallback)(() => {
    if (completedCelGeneration) {
      setShowCelCreateFlyout(false);
      if (celConfig !== undefined) {
        setCelInputResult(celConfig);
      }
    } else {
      setShowValidation(true);
    }
  }, [celConfig, completedCelGeneration, setCelInputResult, setShowCelCreateFlyout]);
  const onCancel = (0, _react.useCallback)(() => {
    setShowCelCreateFlyout(false);
  }, [setShowCelCreateFlyout]);
  const handleToggleStep = () => {
    setIsUploadStepExpanded(!isUploadStepExpanded);
    setIsConfirmStepExpanded(!isConfirmStepExpanded);
  };
  const onAnalyzeApiGenerationComplete = (0, _react.useCallback)(paths => {
    setSuggestedPaths(paths);
    // reset validation and show next step
    setShowValidation(false);
    setNeedsGeneration(true);
    setIsUploadStepExpanded(false);
    setIsConfirmStepExpanded(true);
  }, [setSuggestedPaths]);
  const onCelInputGenerationComplete = (0, _react.useCallback)((path, auth, celInputResult) => {
    setCelConfig(celInputResult);
    setIntegrationSettings({
      ...integrationSettings,
      celPath: path,
      celAuth: auth
    });
    setCompletedCelGeneration(true);
    setShowValidation(false);
  }, [integrationSettings, setIntegrationSettings]);
  const onUpdateValidation = (0, _react.useCallback)(updatedIsValid => {
    setIsValid(updatedIsValid);
  }, []);
  const onShowValidation = (0, _react.useCallback)(() => {
    setShowValidation(true);
  }, []);
  const onUpdateNeedsGeneration = (0, _react.useCallback)(updatedNeedsGeneration => {
    setNeedsGeneration(updatedNeedsGeneration);
  }, []);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setShowCelCreateFlyout(false),
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }, i18n.OPEN_API_SPEC_TITLE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: flyoutBodyCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: 'step1',
    arrowDisplay: "right",
    paddingSize: "m",
    forceState: isUploadStepExpanded ? 'open' : 'closed',
    onToggle: handleToggleStep,
    "data-test-subj": "celGenStep1",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepNumber, {
      titleSize: "s",
      number: 1,
      status: isAnalyzeApiGenerationComplete ? 'complete' : 'current',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 23
      }
    }, i18n.UPLOAD_SPEC_TITLE))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_upload_spec_step.UploadSpecStep, {
    integrationSettings: integrationSettings,
    connector: connector,
    isFlyoutGenerating: isFlyoutGenerating,
    showValidation: showValidation,
    onShowValidation: onShowValidation,
    onUpdateValidation: onUpdateValidation,
    onUpdateNeedsGeneration: onUpdateNeedsGeneration,
    onAnalyzeApiGenerationComplete: onAnalyzeApiGenerationComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: 'step2',
    arrowDisplay: "right",
    paddingSize: "m",
    isDisabled: !isAnalyzeApiGenerationComplete,
    forceState: isConfirmStepExpanded ? 'open' : 'closed',
    onToggle: handleToggleStep,
    "data-test-subj": "celGenStep2",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepNumber, {
      titleSize: "s",
      number: 2,
      status: !isAnalyzeApiGenerationComplete ? 'disabled' : completedCelGeneration ? 'complete' : 'current',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 23
      }
    }, i18n.CONFIRM_SETTINGS_TITLE))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 15
    }
  }, isAnalyzeApiGenerationComplete && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_confirm_settings_step.ConfirmSettingsStep, {
    integrationSettings: integrationSettings,
    connector: connector,
    isFlyoutGenerating: isFlyoutGenerating,
    suggestedPaths: suggestedPaths,
    showValidation: showValidation,
    onShowValidation: onShowValidation,
    onUpdateValidation: onUpdateValidation,
    onUpdateNeedsGeneration: onUpdateNeedsGeneration,
    onCelInputGenerationComplete: onCelInputGenerationComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 21
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    isFlyoutGenerating: isFlyoutGenerating,
    isValid: !showValidation || isValid && completedCelGeneration,
    isGenerationComplete: completedCelGeneration,
    showHint: showValidation && needsGeneration,
    hint: isAnalyzeApiGenerationComplete ? i18n.GENERATE_BUTTON_HINT : i18n.ANALYZE_BUTTON_HINT,
    onCancel: onCancel,
    onSave: onSaveConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  })));
});
CreateCelConfigFlyout.displayName = 'CreateCelConfigFlyout';