"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLinkFlyout = CustomLinkFlyout;
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../hooks/use_fetcher");
var _helper = require("../../app/settings/custom_link/create_edit_custom_link_flyout/helper");
var _create_edit_custom_link_flyout = require("../../app/settings/custom_link/create_edit_custom_link_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/transaction_action_menu/custom_link_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CustomLinkFlyout({
  transaction,
  isOpen,
  onClose
}) {
  const filters = (0, _react.useMemo)(() => {
    var _transaction$service, _transaction$service2, _transaction$transact, _transaction$transact2;
    return [{
      key: 'service.name',
      value: transaction === null || transaction === void 0 ? void 0 : (_transaction$service = transaction.service) === null || _transaction$service === void 0 ? void 0 : _transaction$service.name
    }, {
      key: 'service.environment',
      value: transaction === null || transaction === void 0 ? void 0 : (_transaction$service2 = transaction.service) === null || _transaction$service2 === void 0 ? void 0 : _transaction$service2.environment
    }, {
      key: 'transaction.name',
      value: transaction === null || transaction === void 0 ? void 0 : (_transaction$transact = transaction.transaction) === null || _transaction$transact === void 0 ? void 0 : _transaction$transact.name
    }, {
      key: 'transaction.type',
      value: transaction === null || transaction === void 0 ? void 0 : (_transaction$transact2 = transaction.transaction) === null || _transaction$transact2 === void 0 ? void 0 : _transaction$transact2.type
    }].filter(filter => typeof filter.value === 'string');
  }, [transaction]);
  const {
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi('GET /internal/apm/settings/custom_links', {
    isCachable: false,
    params: {
      query: (0, _helper.convertFiltersToQuery)(filters)
    }
  }), [filters]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isOpen && /*#__PURE__*/_react.default.createElement(_create_edit_custom_link_flyout.CreateEditCustomLinkFlyout, {
    defaults: {
      filters
    },
    onClose: () => {
      onClose();
    },
    onSave: () => {
      onClose();
      refetch();
    },
    onDelete: () => {
      onClose();
      refetch();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }));
}