"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigurations = AgentConfigurations;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _list = require("./list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_configurations/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INITIAL_DATA = {
  configurations: []
};
function AgentConfigurations() {
  const {
    refetch,
    data = INITIAL_DATA,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi('GET /api/apm/settings/agent-configuration 2023-10-31'), [], {
    preservePreviousData: false,
    showToastOnError: false
  });
  const hasConfigurations = !(0, _lodash.isEmpty)(data.configurations);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.agentConfig.configurationsPanelTitle', {
    defaultMessage: 'Configurations'
  })))), hasConfigurations ? /*#__PURE__*/_react.default.createElement(CreateConfigurationButton, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 30
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.settings.agentConfig.descriptionText', {
    defaultMessage: `Fine-tune your agent configuration. Changes are automatically propagated to your APM agents and EDOT SDKs, so there’s no need to redeploy.`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_list.AgentConfigurationList, {
    status: status,
    configurations: data.configurations,
    refetch: refetch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
}
function CreateConfigurationButton() {
  const href = (0, _use_apm_router.useApmRouter)().link('/settings/agent-configuration/create');
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canSave = core.application.capabilities.apm['settings:save'];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !canSave && _i18n.i18n.translate('xpack.apm.agentConfig.configurationsPanelTitle.noPermissionTooltipLabel', {
      defaultMessage: "Your user role doesn't have permissions to create agent configurations"
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmAgentConfigurationButtonCreateConfigurationButton",
    color: "primary",
    fill: true,
    iconType: "plusInCircle",
    href: href,
    isDisabled: !canSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.agentConfig.createConfigButtonLabel', {
    defaultMessage: 'Create configuration'
  }))))));
}