"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateParamsSchema = void 0;
var _v = require("@kbn/zod/v4");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateParamsSchema = actions => {
  const actionKeys = Object.keys(actions);
  if (!actionKeys.length) throw new Error();
  const actionParamSchemas = actionKeys.map(key => _v.z.object({
    subAction: _v.z.literal(key),
    subActionParams: actions[key].input
  }).strict());
  return {
    schema: _v.z.discriminatedUnion('subAction', [
    // to make zod types happy
    actionParamSchemas[0], ...actionParamSchemas.slice(1)])
  };
};
exports.generateParamsSchema = generateParamsSchema;