"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateExecutorFunction = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateExecutorFunction = ({
  actions,
  getAxiosInstanceWithAuth
}) => async function (execOptions) {
  var _data;
  const {
    actionId,
    params,
    secrets,
    logger
  } = execOptions;
  const {
    subAction,
    subActionParams
  } = params;
  let data = null;
  const axiosInstance = await getAxiosInstanceWithAuth({
    ...secrets
  });
  if (!actions[subAction]) {
    const errorMessage = `[Action][ExternalService] Unsupported subAction type ${subAction}.`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }

  // TODO - we need to update ActionContext in the spec
  const actionContext = {
    log: logger,
    client: axiosInstance,
    secrets
  };

  // @ts-ignore
  const res = await actions[subAction].handler(actionContext, subActionParams);
  if (res != null) {
    data = res;
  }
  return {
    status: 'ok',
    data: (_data = data) !== null && _data !== void 0 ? _data : {},
    actionId
  };
};
exports.generateExecutorFunction = generateExecutorFunction;