"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiButtonFocusCSS = exports.useEuiButtonColorCSS = exports.highContrastHoverIndicatorStyles = exports.euiButtonSizeMap = exports.euiButtonFillColor = exports.euiButtonEmptyColor = exports.euiButtonColor = exports.SEVERITY_COLORS = exports.EXTENDED_BUTTON_COLORS = exports.BUTTON_DISPLAYS = exports.BUTTON_COLORS = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _services = require("../../services");
var _functions = require("../functions");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/** Tentative usage; these exist only to be used as button directly when used within other components */
var SEVERITY_COLORS = exports.SEVERITY_COLORS = ['neutral', 'risk'];
var BUTTON_COLORS = exports.BUTTON_COLORS = ['text', 'accent', 'accentSecondary', 'primary', 'success', 'warning', 'danger'];
var EXTENDED_BUTTON_COLORS = exports.EXTENDED_BUTTON_COLORS = [].concat(BUTTON_COLORS, SEVERITY_COLORS);
var BUTTON_DISPLAYS = exports.BUTTON_DISPLAYS = ['base', 'fill', 'empty'];
var getButtonVariantTokenValues = function getButtonVariantTokenValues(_ref, color, variant) {
  var euiTheme = _ref.euiTheme,
    highContrastMode = _ref.highContrastMode;
  var backgroundTokenBase = variant === 'base' ? 'background' : "background".concat(variant.charAt(0).toUpperCase() + variant.slice(1));
  var textTokenBase = variant === 'filled' ? 'textColorFilled' : 'textColor';
  var backgroundTokenName = (0, _euiThemeCommon.getTokenName)(backgroundTokenBase, color);
  var textTokenName = (0, _euiThemeCommon.getTokenName)(textTokenBase, color);
  var backgroundHoverTokenName = (0, _euiThemeCommon.getTokenName)(backgroundTokenBase, color, 'hover');
  var backgroundActiveTokenName = (0, _euiThemeCommon.getTokenName)(backgroundTokenBase, color, 'active');
  var highContrastForeground = ['warning', 'neutral', 'risk'].includes(color) ? euiTheme.colors.ink : color === 'disabled' ? euiTheme.components.buttons[textTokenName] : euiTheme.colors.textInverse;
  var foreground = variant === 'filled' ? highContrastMode ? highContrastForeground : euiTheme.components.buttons[textTokenName] : euiTheme.components.buttons[textTokenName];
  return {
    color: foreground,
    background: euiTheme.components.buttons[backgroundTokenName],
    backgroundHover: euiTheme.components.buttons[backgroundHoverTokenName],
    backgroundActive: euiTheme.components.buttons[backgroundActiveTokenName]
  };
};

/**
 * Creates the `base` version of button styles with proper text contrast.
 * @param euiThemeContext
 * @param color One of the named button colors or 'disabled'
 * @returns Style object `{ backgroundColor, color }`
 */
var euiButtonColor = exports.euiButtonColor = function euiButtonColor(euiThemeContext, color) {
  var buttonColors = getButtonVariantTokenValues(euiThemeContext, color, 'base');
  var foreground = buttonColors.color;
  var background = buttonColors.background;
  return _objectSpread({
    color: background === 'transparent' || color === 'disabled' ? foreground : (0, _services.makeHighContrastColor)(foreground)(background),
    backgroundColor: background
  }, _highContrastBorder(euiThemeContext, foreground));
};

/**
 * Creates the `fill` version of buttons styles with proper text contrast.
 * @param euiThemeContext
 * @param color One of the named button colors or 'disabled'
 * @returns Style object `{ backgroundColor, color }`
 */
var euiButtonFillColor = exports.euiButtonFillColor = function euiButtonFillColor(euiThemeContext, color) {
  var buttonColors = getButtonVariantTokenValues(euiThemeContext, color, 'filled');
  var foreground = buttonColors.color;
  var background = buttonColors.background;
  return _objectSpread({
    color: foreground,
    backgroundColor: background
  }, _highContrastBorder(euiThemeContext, color === 'disabled' ? foreground : background // The border is necessary for Windows high contrast themes, which ignore background-color
  ));
};

/**
 * Creates the `empty` version of button styles using the text-variant and adding interactive styles.
 * @param euiThemeContext
 * @param color One of the named button colors or 'disabled'
 * @returns Style object `{ backgroundColor, color }` where `background` is typically used for interactive states
 */
var euiButtonEmptyColor = exports.euiButtonEmptyColor = function euiButtonEmptyColor(euiThemeContext, color) {
  var foreground;
  var background;
  switch (color) {
    case 'disabled':
      foreground = euiButtonColor(euiThemeContext, color).color;
      background = 'transparent';
      break;
    default:
      {
        var buttonColors = getButtonVariantTokenValues(euiThemeContext, color, 'empty');
        foreground = euiButtonColor(euiThemeContext, color).color;
        background = buttonColors.backgroundHover;
        break;
      }
  }
  return {
    color: foreground,
    backgroundColor: background
  };
};

/**
 * Given the button display type, returns the Emotion based color keys.
 * @param options Button display type
 * @returns An object of `_EuiExtendedButtonColor` keys including `disabled`
 */
var useEuiButtonColorCSS = exports.useEuiButtonColorCSS = function useEuiButtonColorCSS() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var _options$display = options.display,
    display = _options$display === void 0 ? 'base' : _options$display;
  var colorsDisplaysMap = (0, _services.useEuiMemoizedStyles)(euiButtonDisplaysColors);
  return colorsDisplaysMap[display];
};
var euiButtonDisplaysColors = function euiButtonDisplaysColors(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var COLORS = [].concat(_toConsumableArray(EXTENDED_BUTTON_COLORS), ['disabled']);
  var displaysColorsMap = {};
  BUTTON_DISPLAYS.forEach(function (display) {
    displaysColorsMap[display] = {};
    COLORS.forEach(function (color) {
      switch (display) {
        case 'base':
          {
            var buttonColors = getButtonVariantTokenValues(euiThemeContext, color, 'base');
            var borderStyle = color === 'text' && "\n              border: ".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.borderBasePlain, ";\n            ");
            displaysColorsMap[display][color] = /*#__PURE__*/(0, _react.css)(euiButtonColor(euiThemeContext, color), " ", _interactionStyles(euiThemeContext, buttonColors, 'overlay'), " ", borderStyle, ";;label:displaysColorsMap-display-color;");
            break;
          }
        case 'fill':
          {
            var _buttonColors = getButtonVariantTokenValues(euiThemeContext, color, 'filled');
            displaysColorsMap[display][color] = /*#__PURE__*/(0, _react.css)(euiButtonFillColor(euiThemeContext, color), "outline-color:", euiThemeContext.colorMode === 'DARK' && color === 'text' ? 'currentColor' : color !== 'disabled' ? euiThemeContext.euiTheme.colors.fullShade : '', ";", _interactionStyles(euiThemeContext, _buttonColors), ";;label:displaysColorsMap-display-color;");
            break;
          }
        case 'empty':
          {
            var _buttonColors2 = getButtonVariantTokenValues(euiThemeContext, color, 'empty');
            displaysColorsMap[display][color] = /*#__PURE__*/(0, _react.css)("color:", euiButtonEmptyColor(euiThemeContext, color).color, ";", _interactionStyles(euiThemeContext, _buttonColors2, 'overlay'), ";;label:displaysColorsMap-display-color;");
            break;
          }
      }

      // Tweak auto-generated Emotion label/className output
      var emotionOutput = displaysColorsMap[display][color];
      emotionOutput.styles = emotionOutput.styles.replace('label:displaysColorsMap-display-color;', "label:".concat(display, "-").concat(color, ";"));
    });
  });
  return displaysColorsMap;
};

/**
 * Creates the translate animation when button is in focus.
 * @returns string
 */
var useEuiButtonFocusCSS = exports.useEuiButtonFocusCSS = function useEuiButtonFocusCSS() {
  return (0, _services.useEuiMemoizedStyles)(euiButtonFocusCSS);
};

// NOTE: keeping this as placeholder for now in case we need custom button focus styles for https://github.com/elastic/eui-private/issues/267
var euiButtonFocusCSS = function euiButtonFocusCSS(_euiThemeContext) {
  var focusCSS = /*#__PURE__*/(0, _react.css)(";label:focusCSS;");

  // Remove the auto-generated label.
  // We could typically avoid a label by using a plain string `` instead of css``,
  // but we need css`` for keyframes`` to work for the focus animation
  focusCSS.styles = focusCSS.styles.replace('label:focusCSS;', '');
  return focusCSS;
};

/**
 * Map of `size` props to various sizings/scales
 * that should remain consistent across all buttons
 */
var euiButtonSizeMap = exports.euiButtonSizeMap = function euiButtonSizeMap(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    xs: {
      minWidth: euiTheme.base * 6,
      height: euiTheme.size.l,
      radius: euiTheme.border.radius.small,
      fontScale: 'xs'
    },
    s: {
      minWidth: euiTheme.base * 6,
      height: euiTheme.size.xl,
      radius: euiTheme.border.radius.small,
      fontScale: 's'
    },
    m: {
      minWidth: euiTheme.base * 7,
      height: euiTheme.size.xxl,
      radius: euiTheme.border.radius.small,
      fontScale: 's'
    }
  };
};

/**
 * internal styles util for applying button background color on hover
 */
var _interactionStyles = function _interactionStyles(euiThemeContext, buttonColors) {
  var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'fill';
  var baseStyles = function baseStyles() {
    // button hover is applied as pseudo element with a transparent background-color
    if (type === 'overlay') {
      return "\n        position: relative;\n        overflow: hidden;\n\n        &:hover:not(:disabled) {\n          &::before {\n            content: '';\n            position: absolute;\n            /* should stay under the content */\n            z-index: 0;\n            inset: 0;\n            background-color: ".concat(buttonColors.backgroundHover, ";\n            pointer-events: none;\n          }\n        }\n\n        &:active:not(:disabled) {\n          &::before {\n            ").concat((0, _functions.logicalCSS)('width', '100%'), "\n            ").concat((0, _functions.logicalCSS)('height', '100%'), "\n\n            content: '';\n            position: absolute;\n            inset: 0;\n            background-color: ").concat(buttonColors.backgroundActive, ";\n          }\n        }\n      ");
    }

    // button hover is applied as opaque color
    return "\n      &:hover:not(:disabled) {\n        background-color: ".concat(buttonColors.backgroundHover, ";\n      }\n\n      &:active:not(:disabled) {\n        background-color: ").concat(buttonColors.backgroundActive, ";\n      }\n    ");
  };
  return "    \n    ".concat((0, _functions.highContrastModeStyles)(euiThemeContext, {
    none: baseStyles(),
    forced: "\n        position: relative;\n        overflow: hidden;\n\n        ".concat(highContrastHoverIndicatorStyles(euiThemeContext), "\n      ")
  }), "\n  ");
};

/**
 * creates a bottom border on hover/focus to ensure a visible change as forced mode removed background colors
 */
var highContrastHoverIndicatorStyles = exports.highContrastHoverIndicatorStyles = function highContrastHoverIndicatorStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return "\n  &:hover:not(:disabled) {\n    transition: none;\n\n    /* using pseudo border to be able to control the color */\n    &::after {\n      content: '';\n      position: absolute;\n      inset: ".concat(euiTheme.border.width.thin, ";\n      border: ").concat(euiTheme.border.width.thick, " solid var(--highContrastHoverIndicatorColor, ").concat(euiTheme.border.color, ");\n      border-radius: ").concat((0, _euiThemeCommon.mathWithUnits)(euiTheme.border.radius.small, function (x) {
    return x / 2;
  }), ";\n      background-color: transparent;\n      pointer-events: none;\n    }\n  }\n");
};

/**
 * Internal util for high contrast button borders
 */
var _highContrastBorder = function _highContrastBorder(_ref3, color) {
  var highContrastMode = _ref3.highContrastMode,
    euiTheme = _ref3.euiTheme;
  return highContrastMode ? {
    border: "".concat(euiTheme.border.width.thin, " solid ").concat(color)
  } : {};
};