"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PurgeConfirmationContainer = PurgeConfirmationContainer;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _purge_confirmation_modal = require("./purge_confirmation_modal");
var _use_purge_rollup_data = require("../../../pages/slo_management/hooks/use_purge_rollup_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/purge_confirmation_modal/purge_modal_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function PurgeConfirmationContainer({
  item,
  onCancel,
  onConfirm
}) {
  const {
    mutate: purge
  } = (0, _use_purge_rollup_data.usePurgeRollupData)({
    name: item.name,
    onConfirm
  });
  const onClickConfirm = purgePolicyData => {
    const {
      purgeDate,
      purgeType,
      forcePurge,
      age
    } = purgePolicyData;
    purge({
      list: [item.id],
      purgePolicy: purgeType === 'fixed_age' ? {
        purgeType: 'fixed_age',
        age
      } : {
        purgeType: 'fixed_time',
        timestamp: purgeDate.toISOString()
      },
      force: forcePurge
    });
  };
  const MODAL_TITLE = _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.title', {
    defaultMessage: 'Purge {name}',
    values: {
      name: item.name
    }
  });
  const PURGE_POLICY_HELP_TEXT = _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.descriptionText', {
    defaultMessage: 'Rollup data for {name} will be purged according to the policy provided below.',
    values: {
      name: item.name
    }
  });
  return /*#__PURE__*/_react.default.createElement(_purge_confirmation_modal.SloPurgeConfirmationModal, {
    onCancel: onCancel,
    onConfirm: onClickConfirm,
    modalTitle: MODAL_TITLE,
    purgePolicyHelpText: PURGE_POLICY_HELP_TEXT,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
}