"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Windows = Windows;
exports.createNewWindow = exports.calculateMaxBurnRateThreshold = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _uuid = require("uuid");
var _i18nReact = require("@kbn/i18n-react");
var _burn_rate = require("./burn_rate");
var _long_window_duration = require("./long_window_duration");
var _duration = require("../../utils/slo/duration");
var _constants = require("../../../common/constants");
var _budget_consumed = require("./budget_consumed");
var _short_window_duration = require("./short_window_duration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/burn_rate_rule_editor/windows.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ACTION_GROUP_OPTIONS = [{
  value: _constants.ALERT_ACTION.id,
  text: _constants.ALERT_ACTION.name
}, {
  value: _constants.HIGH_PRIORITY_ACTION.id,
  text: _constants.HIGH_PRIORITY_ACTION.name
}, {
  value: _constants.MEDIUM_PRIORITY_ACTION.id,
  text: _constants.MEDIUM_PRIORITY_ACTION.name
}, {
  value: _constants.LOW_PRIORITY_ACTION.id,
  text: _constants.LOW_PRIORITY_ACTION.name
}];
const calculateMaxBurnRateThreshold = (longWindow, slo) => {
  return slo ? Math.floor((0, _duration.toMinutes)((0, _duration.toDuration)(slo.timeWindow.duration)) / (0, _duration.toMinutes)(longWindow)) : Infinity;
};
exports.calculateMaxBurnRateThreshold = calculateMaxBurnRateThreshold;
function Window({
  slo,
  id,
  burnRateThreshold,
  maxBurnRateThreshold,
  longWindow,
  shortWindow,
  actionGroup,
  onChange,
  onDelete,
  errors,
  disableDelete,
  budgetMode = true
}) {
  var _slo$timeWindow$durat;
  const onLongWindowDurationChange = duration => {
    onChange({
      id,
      burnRateThreshold,
      maxBurnRateThreshold,
      longWindow: duration,
      shortWindow,
      actionGroup
    });
  };
  const onShortWindowDurationChange = duration => {
    onChange({
      id,
      burnRateThreshold,
      maxBurnRateThreshold,
      longWindow,
      shortWindow: duration,
      actionGroup
    });
  };
  const onBurnRateChange = value => {
    onChange({
      id,
      burnRateThreshold: value,
      maxBurnRateThreshold: calculateMaxBurnRateThreshold(longWindow, slo),
      longWindow,
      shortWindow,
      actionGroup
    });
  };
  const onActionGroupChange = event => {
    onChange({
      id,
      burnRateThreshold,
      maxBurnRateThreshold,
      longWindow,
      shortWindow,
      actionGroup: event.currentTarget.value
    });
  };
  const computeErrorBudgetExhaustionInHours = () => {
    if (slo && (longWindow === null || longWindow === void 0 ? void 0 : longWindow.value) > 0 && burnRateThreshold >= 1) {
      return (0, _numeral.default)(longWindow.value / (burnRateThreshold * (0, _duration.toMinutes)(longWindow) / (0, _duration.toMinutes)((0, _duration.toDuration)(slo.timeWindow.duration)))).format('0a');
    }
    return 'N/A';
  };
  const sloTimeWindowInHours = Math.round((0, _duration.toMinutes)((0, _duration.toDuration)((_slo$timeWindow$durat = slo === null || slo === void 0 ? void 0 : slo.timeWindow.duration) !== null && _slo$timeWindow$durat !== void 0 ? _slo$timeWindow$durat : '30d')) / 60);
  const computeBudgetConsumed = () => {
    if (slo && longWindow.value > 0 && burnRateThreshold > 0) {
      return burnRateThreshold * longWindow.value / sloTimeWindowInHours;
    }
    return 0;
  };
  const allErrors = [...errors.longWindow, ...errors.burnRateThreshold];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_long_window_duration.LongWindowDuration, {
    initialDuration: longWindow,
    onChange: onLongWindowDurationChange,
    errors: errors.longWindow,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_short_window_duration.ShortWindowDuration, {
    longWindowDuration: longWindow,
    initialDuration: shortWindow,
    onChange: onShortWindowDurationChange,
    errors: errors.shortWindow,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  })), !budgetMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_burn_rate.BurnRate, {
    initialBurnRate: burnRateThreshold,
    maxBurnRate: maxBurnRateThreshold,
    onChange: onBurnRateChange,
    errors: errors.burnRateThreshold,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  })), budgetMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_budget_consumed.BudgetConsumed, {
    initialBurnRate: burnRateThreshold,
    onChange: onBurnRateChange,
    errors: errors.burnRateThreshold,
    sloTimeWindowInHours: sloTimeWindowInHours,
    longLookbackWindowInHours: longWindow.value,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.slo.rules.actionGroupSelectorLabel', {
      defaultMessage: 'Action Group'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "sloBurnRateActionGroupSelctor",
    options: ACTION_GROUP_OPTIONS,
    value: actionGroup,
    onChange: onActionGroupChange,
    "aria-label": _i18n.i18n.translate('xpack.slo.rules.actionGroupSelectorLabel', {
      defaultMessage: 'Action Group'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "sloBurnRateRuleDeleteWindowButton",
    iconType: "trash",
    color: "danger",
    style: {
      marginBottom: '-1em'
    },
    onClick: () => onDelete(id),
    disabled: disableDelete,
    title: _i18n.i18n.translate('xpack.slo.rules.deleteWindowLabel', {
      defaultMessage: 'Delete window'
    }),
    "aria-label": _i18n.i18n.translate('xpack.slo.rules.deleteWindowLabel', {
      defaultMessage: 'Delete window'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }), allErrors.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }, allErrors.map(msg => /*#__PURE__*/_react.default.createElement("p", {
    key: msg,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }, msg))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, getErrorBudgetExhaustionText(computeErrorBudgetExhaustionInHours(), computeBudgetConsumed(), burnRateThreshold, budgetMode))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 7
    }
  }));
}
const getErrorBudgetExhaustionText = (formattedHours, budgetConsumed, burnRateThreshold, budgetMode = false) => budgetMode ? _i18n.i18n.translate('xpack.slo.rules.errorBudgetExhaustion.budgetMode.text', {
  defaultMessage: '{formatedHours} hours until error budget exhaustion. The burn rate threshold is {burnRateThreshold}x.',
  values: {
    formatedHours: formattedHours,
    burnRateThreshold: (0, _numeral.default)(burnRateThreshold).format('0[.0]')
  }
}) : _i18n.i18n.translate('xpack.slo.rules.errorBudgetExhaustion.burnRateMode.text', {
  defaultMessage: '{formatedHours} hours until error budget exhaustion. {budgetConsumed} budget consumed before first alert.',
  values: {
    formatedHours: formattedHours,
    budgetConsumed: (0, _numeral.default)(budgetConsumed).format('0.00%')
  }
});
const createNewWindow = (slo, partialWindow = {}) => {
  const longWindow = partialWindow.longWindow || {
    value: 1,
    unit: 'h'
  };
  return {
    id: (0, _uuid.v4)(),
    burnRateThreshold: 1,
    maxBurnRateThreshold: calculateMaxBurnRateThreshold(longWindow, slo),
    longWindow,
    shortWindow: {
      value: 5,
      unit: 'm'
    },
    actionGroup: _constants.ALERT_ACTION.id,
    ...partialWindow
  };
};
exports.createNewWindow = createNewWindow;
function Windows({
  slo,
  windows,
  errors,
  onChange,
  totalNumberOfWindows
}) {
  const [budgetMode, setBudgetMode] = (0, _react.useState)(true);
  const handleWindowChange = windowDef => {
    onChange(windows.map(def => windowDef.id === def.id ? windowDef : def));
  };
  const handleWindowDelete = id => {
    onChange(windows.length > 1 ? windows.filter(windowDef => windowDef.id !== id) : windows);
  };
  const handleAddWindow = () => {
    onChange([...windows, createNewWindow()]);
  };
  const handleModeChange = () => {
    setBudgetMode(previous => !previous);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.slo.burnRateRuleEditor.h5.defineMultipleBurnRateLabel', {
    defaultMessage: 'Define multiple burn rate windows'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 7
    }
  }), windows.map((windowDef, index) => {
    const windowErrors = errors[index] || {
      longWindow: new Array(),
      shortWindow: new Array(),
      burnRateThreshold: new Array()
    };
    return /*#__PURE__*/_react.default.createElement(Window, (0, _extends2.default)({}, windowDef, {
      key: windowDef.id,
      slo: slo,
      errors: windowErrors,
      onChange: handleWindowChange,
      onDelete: handleWindowDelete,
      disableDelete: windows.length === 1,
      budgetMode: budgetMode,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 11
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "sloBurnRateRuleAddWindowButton",
    color: 'primary',
    size: "s",
    iconType: 'plusInCircleFilled',
    onClick: handleAddWindow,
    isDisabled: windows.length === (totalNumberOfWindows || 4),
    "aria-label": _i18n.i18n.translate('xpack.slo.rules.addWindowAriaLabel', {
      defaultMessage: 'Add window'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.slo.rules.addWIndowLabel",
    defaultMessage: "Add window",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    onChange: handleModeChange,
    checked: !budgetMode,
    label: _i18n.i18n.translate('xpack.slo.rules.useBurnRateModeLabel', {
      defaultMessage: 'Burn rate mode'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 7
    }
  }));
}