"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertTimeTable = AlertTimeTable;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _duration = require("../../utils/slo/duration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/burn_rate_rule_editor/alert_time_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ERROR_RATES = [0.01, 0.1, 0.2, 0.5, 1];
function formatTime(minutes) {
  if (minutes > 59) {
    const mins = minutes % 60;
    const hours = (minutes - mins) / 60;
    return _i18n.i18n.translate('xpack.slo.rules.timeTable.minuteHoursLabel', {
      defaultMessage: '{hours}h {mins}m',
      values: {
        hours,
        mins
      }
    });
  }
  return _i18n.i18n.translate('xpack.slo.rules.timeTable.minuteLabel', {
    defaultMessage: '{minutes}m',
    values: {
      minutes
    }
  });
}
function AlertTimeTable({
  windows,
  slo
}) {
  const rows = ERROR_RATES.map(rate => {
    const windowTimes = windows.reduce((acc, windowDef, index) => {
      const windowInMinutes = (0, _duration.toMinutes)((0, _duration.toDuration)(`${windowDef.longWindow.value}${windowDef.longWindow.unit}`));
      const timeInMinutes = Math.round((1 - slo.objective.target) / rate * windowInMinutes * windowDef.burnRateThreshold);
      return {
        ...acc,
        [`column_${index + 1}`]: timeInMinutes < windowInMinutes ? timeInMinutes : null
      };
    }, {});
    return {
      rate,
      ...windowTimes
    };
  });
  const columns = [{
    field: 'rate',
    name: _i18n.i18n.translate('xpack.slo.rules.timeTable.rateColumnLabel', {
      defaultMessage: 'Error rate'
    }),
    render: rate => (0, _numeral.default)(rate).format('0%')
  }, ...windows.map((windowDef, index) => ({
    field: `column_${index + 1}`,
    name: `${windowDef.longWindow.value}h @ ${(0, _numeral.default)(windowDef.burnRateThreshold).format('0[.0]')}x`,
    align: 'right',
    render: time => time ? formatTime(time) : '-'
  }))];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.slo.rules.timeTable.title', {
    defaultMessage: 'How long will it take for the alert to fire?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.slo.rules.timeTable.description', {
    defaultMessage: 'The table below lists the error rates and approximately how long it would take to receive your first alert with the current configuration.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: _i18n.i18n.translate('xpack.slo.rules.tableCaption', {
      defaultMessage: 'Alerting time table'
    }),
    items: rows,
    columns: columns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }));
}