"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.linkTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _context = require("../../context");
var _link_content = require("./link_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/share/public/components/tabs/link/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LINK_TAB_ACTIONS = {
  SET_DASHBOARD_URL: 'SET_DASHBOARD_URL',
  SET_IS_NOT_SAVED: 'SET_IS_NOT_SAVED'
};
const linkTabReducer = (state = {
  dashboardUrl: '',
  isNotSaved: false,
  setIsClicked: false
}, action) => {
  switch (action.type) {
    case LINK_TAB_ACTIONS.SET_DASHBOARD_URL:
      return {
        ...state,
        dashboardUrl: action.payload
      };
    case LINK_TAB_ACTIONS.SET_IS_NOT_SAVED:
      return {
        ...state,
        isNotSaved: action.payload
      };
    default:
      return state;
  }
};
const LinkTabContent = ({
  state,
  dispatch
}) => {
  const {
    objectType,
    objectTypeMeta,
    objectId,
    isDirty,
    shareableUrl,
    shareableUrlLocatorParams,
    allowShortUrl,
    shareMenuItems
  } = (0, _context.useShareTypeContext)('link');
  const setDashboardLink = (0, _react.useCallback)(url => {
    dispatch({
      type: LINK_TAB_ACTIONS.SET_DASHBOARD_URL,
      payload: url
    });
  }, [dispatch]);
  const setIsNotSaved = (0, _react.useCallback)(() => {
    dispatch({
      type: LINK_TAB_ACTIONS.SET_IS_NOT_SAVED,
      payload: objectType === 'lens' || objectType === 'dashboard' && !allowShortUrl ? isDirty : false
    });
  }, [dispatch, objectType, isDirty, allowShortUrl]);
  const setIsClicked = (0, _react.useCallback)(() => {
    dispatch({
      type: LINK_TAB_ACTIONS.SET_IS_NOT_SAVED,
      payload: setIsClicked
    });
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_link_content.LinkContent, {
    objectType,
    objectConfig: objectTypeMeta === null || objectTypeMeta === void 0 ? void 0 : objectTypeMeta.config,
    objectId,
    isDirty,
    shareableUrl,
    shortUrlService: shareMenuItems.config.shortUrlService,
    shareableUrlLocatorParams,
    dashboardLink: state === null || state === void 0 ? void 0 : state.dashboardUrl,
    setDashboardLink,
    isNotSaved: state === null || state === void 0 ? void 0 : state.isNotSaved,
    setIsNotSaved,
    allowShortUrl,
    setIsClicked: state === null || state === void 0 ? void 0 : state.setIsClicked,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  });
};
const linkTab = exports.linkTab = {
  id: 'link',
  name: _i18n.i18n.translate('share.contextMenu.permalinksTab', {
    defaultMessage: 'Link'
  }),
  description: _i18n.i18n.translate('share.dashboard.link.description', {
    defaultMessage: 'Share a direct link to this search.'
  }),
  content: LinkTabContent,
  reducer: linkTabReducer
};