"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessPlugin = void 0;
var _navigation = require("./navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessPlugin {
  constructor() {}
  setup(_core, _dependencies) {
    return {};
  }
  start(core, dependencies) {
    const {
      chrome
    } = core;

    // Casting the "chrome.project" service to an "internal" type: this is intentional to obscure the property from Typescript.
    const {
      project
    } = chrome;
    const {
      cloud
    } = dependencies;
    chrome.setChromeStyle('project');
    if (cloud.serverless.projectName) {
      project.setKibanaName(cloud.serverless.projectName);
    }
    project.setCloudUrls(cloud.getUrls()); // Ensure the project has the non-privileged URLs immediately
    cloud.getPrivilegedUrls().then(privilegedUrls => {
      if (Object.keys(privilegedUrls).length === 0) return;
      project.setCloudUrls({
        ...privilegedUrls,
        ...cloud.getUrls()
      }); // Merge the privileged URLs once available
    });
    return {
      initNavigation: (id, navigationTree$, config) => {
        project.initNavigation(id, navigationTree$, config);
      },
      setBreadcrumbs: (breadcrumbs, params) => project.setBreadcrumbs(breadcrumbs, params),
      setProjectHome: homeHref => project.setHome(homeHref),
      getNavigationCards: (roleManagementEnabled, extendCardNavDefinitions) => {
        if (!roleManagementEnabled) return extendCardNavDefinitions;
        const manageOrgMembersNavCard = (0, _navigation.generateManageOrgMembersNavCard)(cloud.usersAndRolesUrl);
        if (extendCardNavDefinitions) {
          extendCardNavDefinitions[_navigation.manageOrgMembersNavCardName] = manageOrgMembersNavCard;
          return extendCardNavDefinitions;
        }
        return {
          [_navigation.manageOrgMembersNavCardName]: manageOrgMembersNavCard
        };
      }
    };
  }
  stop() {}
}
exports.ServerlessPlugin = ServerlessPlugin;