"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessObservabilityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverlessObservabilitySettings = require("@kbn/serverless-observability-settings");
var _common = require("@kbn/streams-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessObservabilityPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(coreSetup, pluginsSetup) {
    coreSetup.pricing.isFeatureAvailable(_common.STREAMS_TIERED_SIGNIFICANT_EVENT_FEATURE.id).then(isSignificantEventsAvailable => {
      pluginsSetup.serverless.setupProjectSettings([..._serverlessObservabilitySettings.OBSERVABILITY_PROJECT_SETTINGS, ...(isSignificantEventsAvailable ? _serverlessObservabilitySettings.OBSERVABILITY_STREAMS_TIERED_PROJECT_SETTINGS : []), ...(pluginsSetup.observabilityAIAssistant ? _serverlessObservabilitySettings.OBSERVABILITY_AI_ASSISTANT_PROJECT_SETTINGS : [])]);
    }).catch(error => {
      this.logger.error(`Error setup serverless project settings: ${error}`);
    });
    coreSetup.pricing.registerProductFeatures([{
      id: 'observability:complete_overview',
      products: [{
        name: 'observability',
        tier: 'complete'
      }],
      description: 'Observability Overview Complete - Enables overview of the Observability solution.'
    }]);
    return {};
  }
  start() {
    return {};
  }
  stop() {}
}
exports.ServerlessObservabilityPlugin = ServerlessObservabilityPlugin;