"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionNamespaceTypeEnum = exports.ExceptionNamespaceType = exports.ExceptionListVersion = exports.ExceptionListTypeEnum = exports.ExceptionListType = exports.ExceptionListTags = exports.ExceptionListSO = exports.ExceptionListOsTypeEnum = exports.ExceptionListOsTypeArray = exports.ExceptionListOsType = exports.ExceptionListName = exports.ExceptionListMeta = exports.ExceptionListItemType = exports.ExceptionListItemTags = exports.ExceptionListItemOsTypeEnum = exports.ExceptionListItemOsTypeArray = exports.ExceptionListItemOsType = exports.ExceptionListItemName = exports.ExceptionListItemMeta = exports.ExceptionListItemId = exports.ExceptionListItemHumanId = exports.ExceptionListItemExpireTime = exports.ExceptionListItemDescription = exports.ExceptionListItemCommentArray = exports.ExceptionListItemComment = exports.ExceptionListItem = exports.ExceptionListId = exports.ExceptionListHumanId = exports.ExceptionListDescription = exports.ExceptionList = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _primitives = require("@kbn/openapi-common/schemas/primitives.gen");
var _exception_list_item_entry = require("./exception_list_item_entry.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Exception List Attributes
 *   version: not applicable
 */

/**
 * Exception list's identifier.
 */

const ExceptionListId = exports.ExceptionListId = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * The exception list's human readable string identifier, `endpoint_list`.
 */

const ExceptionListHumanId = exports.ExceptionListHumanId = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * The type of exception list to be created. Different list types may denote where they can be utilized.
 */

const ExceptionListType = exports.ExceptionListType = _zod.z.enum(['detection', 'rule_default', 'endpoint', 'endpoint_trusted_apps', 'endpoint_trusted_devices', 'endpoint_events', 'endpoint_host_isolation_exceptions', 'endpoint_blocklists']);
const ExceptionListTypeEnum = exports.ExceptionListTypeEnum = ExceptionListType.enum;

/**
 * The name of the exception list.
 */

const ExceptionListName = exports.ExceptionListName = _zod.z.string();

/**
 * Describes the exception list.
 */

const ExceptionListDescription = exports.ExceptionListDescription = _zod.z.string();

/**
 * Placeholder for metadata about the list container.
 */

const ExceptionListMeta = exports.ExceptionListMeta = _zod.z.object({}).catchall(_zod.z.unknown());

/**
  * Determines whether the exception container is available in all Kibana spaces or just the space
in which it is created, where:

- `single`: Only available in the Kibana space in which it is created.
- `agnostic`: Available in all Kibana spaces.

  */

const ExceptionNamespaceType = exports.ExceptionNamespaceType = _zod.z.enum(['agnostic', 'single']);
const ExceptionNamespaceTypeEnum = exports.ExceptionNamespaceTypeEnum = ExceptionNamespaceType.enum;

/**
 * String array containing words and phrases to help categorize exception containers.
 */

const ExceptionListTags = exports.ExceptionListTags = _zod.z.array(_zod.z.string());

/**
 * Use this field to specify the operating system.
 */

const ExceptionListOsType = exports.ExceptionListOsType = _zod.z.enum(['linux', 'macos', 'windows']);
const ExceptionListOsTypeEnum = exports.ExceptionListOsTypeEnum = ExceptionListOsType.enum;

/**
 * Use this field to specify the operating system. Only enter one value.
 */

const ExceptionListOsTypeArray = exports.ExceptionListOsTypeArray = _zod.z.array(ExceptionListOsType);

/**
 * The document version, automatically increasd on updates.
 */

const ExceptionListVersion = exports.ExceptionListVersion = _zod.z.number().int().min(1);
const ExceptionList = exports.ExceptionList = _zod.z.object({
  id: ExceptionListId,
  list_id: ExceptionListHumanId,
  type: ExceptionListType,
  name: ExceptionListName,
  description: ExceptionListDescription,
  immutable: _zod.z.boolean(),
  namespace_type: ExceptionNamespaceType,
  os_types: ExceptionListOsTypeArray.optional(),
  tags: ExceptionListTags.optional(),
  meta: ExceptionListMeta.optional(),
  version: ExceptionListVersion,
  /**
   * The version id, normally returned by the API when the item was retrieved. Use it ensure updates are done against the latest version.
   */
  _version: _zod.z.string().optional(),
  /**
   * Field used in search to ensure all containers are sorted and returned correctly.
   */
  tie_breaker_id: _zod.z.string(),
  /**
   * Autogenerated date of object creation.
   */
  created_at: _zod.z.string().datetime(),
  /**
   * Autogenerated value - user that created object.
   */
  created_by: _zod.z.string(),
  /**
   * Autogenerated date of last object update.
   */
  updated_at: _zod.z.string().datetime(),
  /**
   * Autogenerated value - user that last updated object.
   */
  updated_by: _zod.z.string()
});

/**
 * Exception's identifier.
 */

const ExceptionListItemId = exports.ExceptionListItemId = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * Human readable string identifier, e.g. `trusted-linux-processes`
 */

const ExceptionListItemHumanId = exports.ExceptionListItemHumanId = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);
const ExceptionListItemType = exports.ExceptionListItemType = _zod.z.literal('simple');

/**
 * Exception list name.
 */

const ExceptionListItemName = exports.ExceptionListItemName = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * Describes the exception list.
 */

const ExceptionListItemDescription = exports.ExceptionListItemDescription = _zod.z.string();
const ExceptionListItemMeta = exports.ExceptionListItemMeta = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * The exception item’s expiration date, in ISO format. This field is only available for regular exception items, not endpoint exceptions.
 */

const ExceptionListItemExpireTime = exports.ExceptionListItemExpireTime = _zod.z.string().datetime();
const ExceptionListItemTags = exports.ExceptionListItemTags = _zod.z.array(_zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString));
const ExceptionListItemOsType = exports.ExceptionListItemOsType = _zod.z.enum(['linux', 'macos', 'windows']);
const ExceptionListItemOsTypeEnum = exports.ExceptionListItemOsTypeEnum = ExceptionListItemOsType.enum;
const ExceptionListItemOsTypeArray = exports.ExceptionListItemOsTypeArray = _zod.z.array(ExceptionListOsType);
const ExceptionListItemComment = exports.ExceptionListItemComment = _zod.z.object({
  id: _primitives.NonEmptyString,
  comment: _primitives.NonEmptyString,
  /**
   * Autogenerated date of object creation.
   */
  created_at: _zod.z.string().datetime(),
  created_by: _primitives.NonEmptyString,
  /**
   * Autogenerated date of last object update.
   */
  updated_at: _zod.z.string().datetime().optional(),
  updated_by: _primitives.NonEmptyString.optional()
});

/**
  * Array of comment fields:

- comment (string): Comments about the exception item.

  */

const ExceptionListItemCommentArray = exports.ExceptionListItemCommentArray = _zod.z.array(ExceptionListItemComment);
const ExceptionListItem = exports.ExceptionListItem = _zod.z.object({
  id: ExceptionListItemId,
  item_id: ExceptionListItemHumanId,
  list_id: ExceptionListHumanId,
  type: ExceptionListItemType,
  name: ExceptionListItemName,
  description: ExceptionListItemDescription,
  entries: _exception_list_item_entry.ExceptionListItemEntryArray,
  namespace_type: ExceptionNamespaceType,
  os_types: ExceptionListItemOsTypeArray.optional(),
  tags: ExceptionListItemTags.optional(),
  meta: ExceptionListItemMeta.optional(),
  expire_time: ExceptionListItemExpireTime.optional(),
  comments: ExceptionListItemCommentArray,
  /**
   * The version id, normally returned by the API when the item was retrieved. Use it ensure updates are done against the latest version.
   */
  _version: _zod.z.string().optional(),
  /**
   * Field used in search to ensure all containers are sorted and returned correctly.
   */
  tie_breaker_id: _zod.z.string(),
  /**
   * Autogenerated date of object creation.
   */
  created_at: _zod.z.string().datetime(),
  /**
   * Autogenerated value - user that created object.
   */
  created_by: _zod.z.string(),
  /**
   * Autogenerated date of last object update.
   */
  updated_at: _zod.z.string().datetime(),
  /**
   * Autogenerated value - user that last updated object.
   */
  updated_by: _zod.z.string()
});
const ExceptionListSO = exports.ExceptionListSO = _zod.z.object({
  item_id: ExceptionListItemHumanId.optional(),
  list_id: ExceptionListHumanId,
  list_type: _zod.z.enum(['item', 'list']),
  immutable: _zod.z.boolean().optional(),
  type: ExceptionListItemType,
  name: ExceptionListItemName,
  description: ExceptionListItemDescription,
  entries: _exception_list_item_entry.ExceptionListItemEntryArray.optional(),
  os_types: ExceptionListItemOsTypeArray.optional(),
  tags: ExceptionListItemTags.optional(),
  meta: ExceptionListItemMeta.optional(),
  expire_time: ExceptionListItemExpireTime.optional(),
  comments: ExceptionListItemCommentArray.optional(),
  version: _primitives.NonEmptyString.optional(),
  /**
   * Field used in search to ensure all containers are sorted and returned correctly.
   */
  tie_breaker_id: _zod.z.string(),
  /**
   * Autogenerated date of object creation.
   */
  created_at: _zod.z.string().datetime(),
  /**
   * Autogenerated value - user that created object.
   */
  created_by: _zod.z.string(),
  /**
   * Autogenerated value - user that last updated object.
   */
  updated_by: _zod.z.string()
});