"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyProtections = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution_serverless/public/upselling/sections/endpoint_management/endpoint_policy_protections.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CARD_TITLE = _i18n.i18n.translate('xpack.securitySolutionServerless.endpointPolicyProtections.cardTitle', {
  defaultMessage: 'Policy Protections'
});
const CARD_MESSAGE = _i18n.i18n.translate('xpack.securitySolutionServerless.endpointPolicyProtections.cardMessage', {
  defaultMessage: 'To turn on policy protections, like malware, ransomware and others, you must add at least Endpoint Essentials to your project. '
});
const BADGE_TEXT = _i18n.i18n.translate('xpack.securitySolutionServerless.endpointPolicyProtections.badgeText', {
  defaultMessage: 'Endpoint Essentials'
});
const CardDescription = _styled.default.p`
  padding: 0 33.3%;
`;

/**
 * Component displayed when a given product tier is not allowed to use endpoint policy protections.
 */
const EndpointPolicyProtections = exports.EndpointPolicyProtections = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "endpointPolicy-protectionsLockedCard",
    isDisabled: true,
    description: false,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "lock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 13
      }
    }),
    betaBadgeProps: {
      'data-test-subj': 'endpointPolicy-protectionsLockedCard-badge',
      label: BADGE_TEXT
    },
    title: /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "endpointPolicy-protectionsLockedCard-title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }, CARD_TITLE)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CardDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, CARD_MESSAGE));
});
EndpointPolicyProtections.displayName = 'EndpointPolicyProtections';