/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.securitySolution_bundle_jsonpfunction=self.securitySolution_bundle_jsonpfunction||[]).push([[9410],{79410:(M,D,N)=>{N.r(D),N.d(D,{default:()=>G});var I=N(84286),j=N(81319),i=N(75008),T=N(96791),g=N(13530),A=N(20409);const z=[{id:"lets-get-started",title:i.i18n.translate("xpack.securitySolution.readinessTask.letsGetStarted.title",{defaultMessage:"Lets get started"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.letsGetStarted.description",{defaultMessage:"To complete this task, we need a bit more information about your infrastructure. Select the platforms you use (e.g. AWS, Azure, GCP, On-prem). This helps us tailor recommendations and accurately measure your readiness."}),pillar:"visibility",order:1,taskNumber:"1"},{id:"enable-endpoint-visibility",title:i.i18n.translate("xpack.securitySolution.readinessTask.enableEndpointVisibility.title",{defaultMessage:"Enable Endpoint Visibility"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.enableEndpointVisibility.description",{defaultMessage:"Choose one of the following:\n  1. Deploy Elastic Defend to gain rich host and process telemetry\n  2. Ingest logs from existing endpoint protection tools (e.g. CrowdStrike, SentinelOne, Microsoft Defender) using supported integrations.\nThis enables foundational endpoint visibility for investigation and detection."}),pillar:"visibility",order:2,taskNumber:"2"},{id:"ingest-cloud-audit-logs",title:i.i18n.translate("xpack.securitySolution.readinessTask.ingestCloudAuditLogs.title",{defaultMessage:"Ingest cloud/audit logs (AWS, GCP, Azure, On prem)"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.ingestCloudAuditLogs.description",{defaultMessage:"Set up integrations for AWS CloudTrail, Azure Activity, GCP Admin Activity, or on-prem audit logs"}),pillar:"visibility",order:3,taskNumber:"3"},{id:"ingest-asset-inventory",title:i.i18n.translate("xpack.securitySolution.readinessTask.ingestAssetInventory.title",{defaultMessage:"Ingest asset inventory"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.ingestAssetInventory.description",{defaultMessage:"Automatically pull and index asset metadata from cloud (via integrations) or via endpoint agent. View in Asset Inventory dashboard"}),pillar:"visibility",order:7,taskNumber:"4"},{id:"enable-kubernetes-container-logs",title:i.i18n.translate("xpack.securitySolution.readinessTask.enableKubernetesContainerLogs.title",{defaultMessage:"Enable Kubernetes or container logs"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.enableKubernetesContainerLogs.description",{defaultMessage:"Set up the Kubernetes integration for kubernetes.audit_logs and/or container runtime logs."}),pillar:"visibility",order:11,taskNumber:"5"},{id:"ingest-all-cloud-logs-inventory",title:i.i18n.translate("xpack.securitySolution.readinessTask.ingestAllCloudLogsInventory.title",{defaultMessage:"Ingest all 3 major cloud providers (AWS, Azure, GCP) logs and Cloud Asset Inventory"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.ingestAllCloudLogsInventory.description",{defaultMessage:"Onboard audit + inventory data for AWS, Azure, and GCP to show multi-cloud coverage."}),pillar:"visibility",order:16,taskNumber:"6"},{id:"enable-mitre-aligned-detection-rules",title:i.i18n.translate("xpack.securitySolution.readinessTask.enableMitreAlignedDetectionRules.title",{defaultMessage:"Enable MITRE-aligned detection rules"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.enableMitreAlignedDetectionRules.description",{defaultMessage:"Enable Elastic's prebuilt rules mapped to MITRE ATT&CK. Evaluate rule coverage across key tactics."}),pillar:"detection",order:4,taskNumber:"1"},{id:"view-detection-coverage-mitre",title:i.i18n.translate("xpack.securitySolution.readinessTask.viewDetectionCoverageMitre.title",{defaultMessage:"View detection coverage across MITRE matrix"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.viewDetectionCoverageMitre.description",{defaultMessage:"Show tactics and techniques covered by active rules in a heatmap. Track posture"}),pillar:"detection",order:5,taskNumber:"2"},{id:"add-threat-intel-feeds",title:i.i18n.translate("xpack.securitySolution.readinessTask.addThreatIntelFeeds.title",{defaultMessage:"Add threat intelligence feeds"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.addThreatIntelFeeds.description",{defaultMessage:"Integrate threat intel (Abuse.ch, etc.) to enrich alerts and correlate known IOCs."}),pillar:"detection",order:8,taskNumber:"3"},{id:"customize-create-rules",title:i.i18n.translate("xpack.securitySolution.readinessTask.customizeCreateRules.title",{defaultMessage:"Customize or create new detection rules"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.customizeCreateRules.description",{defaultMessage:"Modify a rule or author a new one using KQL/ES QL. Demonstrates SOC maturity."}),pillar:"detection",order:9,taskNumber:"4"},{id:"use-attack-discovery",title:i.i18n.translate("xpack.securitySolution.readinessTask.useAttackDiscovery.title",{defaultMessage:"Use Attack Discovery to trace MITRE-mapped threat activity"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.useAttackDiscovery.description",{defaultMessage:"Visualize threats in MITRE ATT&CK graph via Attack Discovery. Correlates alerts to kill chain."}),pillar:"detection",order:12,taskNumber:"5"},{id:"maintain-rule-coverage",title:i.i18n.translate("xpack.securitySolution.readinessTask.maintainRuleCoverage.title",{defaultMessage:"Maintain >90% rule coverage"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.maintainRuleCoverage.description",{defaultMessage:"Ensure high-severity rules are enabled"}),pillar:"detection",order:14,taskNumber:"6"},{id:"enable-cspm-on-all-clouds",title:i.i18n.translate("xpack.securitySolution.readinessTask.enableCspmOnAllClouds.title",{defaultMessage:"Enable CSPM on all 3 major cloud providers (AWS, Azure, GCP)"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.enableCspmOnAllClouds.description",{defaultMessage:"Activate cloud security posture monitoring (CSPM) for AWS, Azure, GCP. Review active findings."}),pillar:"detection",order:17,taskNumber:"7"},{id:"investigate-alert-using-timeline",title:i.i18n.translate("xpack.securitySolution.readinessTask.investigateAlertUsingTimeline.title",{defaultMessage:"Investigate an alert using Timeline"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.investigateAlertUsingTimeline.description",{defaultMessage:"Triage an alert using the Timeline view. Add evidence and enrich context."}),pillar:"response",order:6,taskNumber:"1"},{id:"use-ai-assistant-for-alert-root-cause",title:i.i18n.translate("xpack.securitySolution.readinessTask.useAiAssistantForAlertRootCause.title",{defaultMessage:"Use AI Assistant to summarize alert context or identify root cause"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.useAiAssistantForAlertRootCause.description",{defaultMessage:'Ask AI to generate a quick summary or root cause for an alert. Prompt: "Summarize the root cause for this alert"'}),pillar:"response",order:10,taskNumber:"2"},{id:"add-external-connectors",title:i.i18n.translate("xpack.securitySolution.readinessTask.addExternalConnectors.title",{defaultMessage:"Add external connectors (Jira, Slack, ServiceNow)"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.addExternalConnectors.description",{defaultMessage:"Configure Jira, Slack, or ServiceNow for alert or case forwarding."}),pillar:"response",order:13,taskNumber:"3"},{id:"automate-response-rules-case-creation",title:i.i18n.translate("xpack.securitySolution.readinessTask.automateResponseRulesCaseCreation.title",{defaultMessage:"Automate response rules or case creation for alerts"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.automateResponseRulesCaseCreation.description",{defaultMessage:"Use rule actions or case templates to automatically trigger cases or actions"}),pillar:"response",order:15,taskNumber:"4"},{id:"create-manage-case-workflows",title:i.i18n.translate("xpack.securitySolution.readinessTask.createManageCaseWorkflows.title",{defaultMessage:"Create and manage case workflows"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.createManageCaseWorkflows.description",{defaultMessage:"Open a case, assign it, and link alerts to it. Manages SOC workflow maturity."}),pillar:"response",order:18,taskNumber:"5"},{id:"complete-automated-cases",title:i.i18n.translate("xpack.securitySolution.readinessTask.completeAutomatedCases.title",{defaultMessage:"Complete 3+ cases with automation and external sharing"}),description:i.i18n.translate("xpack.securitySolution.readinessTask.completeAutomatedCases.description",{defaultMessage:"Demonstrate workflow maturity by automating and resolving multiple cases."}),pillar:"response",order:19,taskNumber:"6"}],O=z.map((M=>M.id)),u=["completed","incomplete"],k=["latest-readiness-tasks"],L=()=>{const{http:M}=(0,A.useKibana)().services,D=(0,g.useQueryClient)(),{mutate:N}=(0,g.useMutation)({mutationFn:async D=>{(M=>{const D=z.find((D=>D.id===M.task_id));if(!D)throw new Error(`Invalid task_id: ${M.task_id}. Must be one of: ${O.join(", ")}`);if(!u.includes(M.status))throw new Error(`Invalid status: ${M.status}. Must be one of: ${u.join(", ")}`);const N=D.meta;if(!N&&M.meta)throw new Error(`Task ${M.task_id} should not have a meta field`);if(N){if(!("meta"in M)||!M.meta)throw new Error(`Task ${M.task_id} should have a meta field`);const D=Object.keys(N);if("object"!=typeof M.meta)throw new Error(`Meta must be an object for task ${M.task_id}, and include the fields ${D.join(", ")}`);const I=M.meta,j=Object.keys(I);D.forEach((D=>{if(!(D in I))throw new Error(`Missing required meta field: ${D} for task ${M.task_id}`);const j=typeof N[D],i=typeof I[D];if(j!==i)throw new Error(`Invalid type for meta field: ${D} in task ${M.task_id}. Expected ${j}, got ${i}`)}));const i=j.filter((M=>!D.includes(M)));if(i.length>0)throw new Error(`Unexpected meta fields for task ${M.task_id}: ${i.join(", ")}`)}})(D),await M.post("/api/siem_readiness/post_task",{body:JSON.stringify(D)})},onSuccess:()=>{D.invalidateQueries({queryKey:k})}});return{logReadinessTask:N,getLatestTasks:(0,g.useQuery)({queryKey:k,queryFn:()=>M.get("/api/siem_readiness/get_latest_tasks")})}},y=()=>{const{getLatestTasks:M}=L();return{readinessTasksStats:(0,I.useMemo)((()=>{const D=M.data||[],N=new Set(D.filter((M=>"completed"===M.status)).map((M=>M.task_id))),I={visibility:{completed:0,total:0},detection:{completed:0,total:0},response:{completed:0,total:0}};z.forEach((M=>{I[M.pillar].total++,N.has(M.id)&&I[M.pillar].completed++}));const j=z.length,i=Object.values(I).reduce(((M,D)=>M+D.completed),0);return{pillarStatsMap:I,totalCompleted:i,totalTasks:j,totalIncomplete:j-i}}),[M])}},a=()=>{const{euiTheme:M}=(0,j.useEuiTheme)();return{pillarPropsMap:{visibility:{pillarKey:"visibility",displayName:i.i18n.translate("xpack.securitySolution.siemReadiness.visibility.displayName",{defaultMessage:"Visibility"}),color:M.colors.vis.euiColorVisBehindText2,description:i.i18n.translate("xpack.securitySolution.siemReadiness.visibility.description",{defaultMessage:"Your visibility score is how well your systems are monitored through logs, agents, and cloud telemetry."}),icon:"eye"},detection:{pillarKey:"detection",displayName:i.i18n.translate("xpack.securitySolution.siemReadiness.detection.displayName",{defaultMessage:"Detection"}),color:M.colors.vis.euiColorVisBehindText4,description:i.i18n.translate("xpack.securitySolution.siemReadiness.detection.description",{defaultMessage:"Detections measure how well your system identifies threats through tuned, active detection rules."}),icon:"securitySignal"},response:{pillarKey:"response",displayName:i.i18n.translate("xpack.securitySolution.siemReadiness.response.displayName",{defaultMessage:"Response"}),color:M.colors.vis.euiColorVisBehindText0,description:i.i18n.translate("xpack.securitySolution.siemReadiness.response.description",{defaultMessage:"Response shows how quickly and effectively your team investigates and acts on detected threats."}),icon:"magnifyWithExclamation"}}}},e="#966B03",x=({pillarProps:M,pillarStats:D})=>{const{completed:N,total:I}=D,{euiTheme:g}=(0,j.useEuiTheme)();return(0,T.jsx)(j.EuiFlexGroup,{direction:"row",gutterSize:"none"},(0,T.jsx)(j.EuiFlexItem,{grow:!1},(0,T.jsx)(j.EuiProgress,{value:N,max:I,size:"m",color:M.color,css:(0,T.css)({transform:"rotate(-90deg)",position:"absolute",top:"70px",left:"-42px",width:120},"","")})),(0,T.jsx)(j.EuiFlexItem,{grow:9},(0,T.jsx)(j.EuiFlexGroup,{direction:"column",gutterSize:"s",css:(0,T.css)({height:"100%",paddingLeft:g.size.base,minHeight:120},"","")},(0,T.jsx)(j.EuiFlexItem,{grow:1},(0,T.jsx)(j.EuiFlexGroup,{direction:"row",alignItems:"baseline",gutterSize:"s"},(0,T.jsx)(j.EuiTitle,{size:"l"},(0,T.jsx)("span",null,`${N}/${I}`)),(0,T.jsx)(j.EuiTitle,{size:"xs"},(0,T.jsx)("span",null,i.i18n.translate("xpack.securitySolution.siemReadiness.tasksCompletedLabel",{defaultMessage:"Tasks completed"}))))),(0,T.jsx)(j.EuiFlexItem,{grow:1},(0,T.jsx)(j.EuiTitle,{size:"xs"},(0,T.jsx)("h3",{style:{marginBottom:g.size.xxs}},M.displayName)),(0,T.jsx)(j.EuiText,{size:"s"},(0,T.jsx)("p",null,M.description))))))},w=({pillarProps:M,pillarStats:D})=>{const{euiTheme:N}=(0,j.useEuiTheme)(),{completed:I,total:g}=D,A=Math.ceil(g/2);let z=0;z=I>=g?0:I>=A?g-I:I>=1?A-I:1-I;const O=I,u=g,k=I>=1,L=I>=A,y=I>=g,a=N.colors.severity.unknown,x={bronze:k?e:a,silver:L?"#5A6D8C":a,gold:y?"#F5BC00":a},w={position:"absolute",top:"-5px",display:"flex",flexDirection:"column",alignItems:"center"},c=[{key:"bronze",left:"0%",transform:"translateX(-50%)",color:x.bronze,label:i.i18n.translate("xpack.securitySolution.siemReadiness.bronzeLevelLabel",{defaultMessage:"Bronze"})},{key:"silver",left:"calc(50% - 8px)",transform:"none",color:x.silver,label:i.i18n.translate("xpack.securitySolution.siemReadiness.silverLevelLabel",{defaultMessage:"Silver"})},{key:"gold",left:"100%",transform:"translateX(-50%)",color:x.gold,label:i.i18n.translate("xpack.securitySolution.siemReadiness.goldLevelLabel",{defaultMessage:"Gold"})}];return(0,T.jsx)(j.EuiFlexGroup,{direction:"column",gutterSize:"m"},(0,T.jsx)(j.EuiFlexItem,null,(0,T.jsx)(j.EuiFlexGroup,{direction:"row",justifyContent:"spaceBetween",alignItems:"center"},(0,T.jsx)(j.EuiFlexItem,{grow:!1},(0,T.jsx)(j.EuiTitle,{size:"xxs"},(0,T.jsx)("h4",null,i.i18n.translate("xpack.securitySolution.siemReadiness.yourCurrentLevelLabel",{defaultMessage:"Your current level"})))),(0,T.jsx)(j.EuiFlexItem,{grow:!1},z>0?(0,T.jsx)(j.EuiBadge,{iconType:"bullseye",color:N.colors.backgroundTransparentPlain,css:(0,T.css)({color:N.colors.primary},"","")},i.i18n.translate("xpack.securitySolution.siemReadiness.tasksToNextLevelBadge",{defaultMessage:"{count} tasks to next level",values:{count:z}})):(0,T.jsx)(j.EuiBadge,{iconType:"check",color:"hollow"},i.i18n.translate("xpack.securitySolution.siemReadiness.allTasksCompleteBadge",{defaultMessage:"All tasks complete"}))))),(0,T.jsx)(j.EuiFlexItem,{style:{padding:"0 16px"}},(0,T.jsx)("div",{style:{position:"relative"}},(0,T.jsx)(j.EuiProgress,{color:M.color,value:O,max:u,size:"s"}),c.map((M=>(0,T.jsx)("div",{key:M.key,style:{...w,left:M.left,transform:M.transform}},(0,T.jsx)(l,{color:M.color}),(0,T.jsx)(j.EuiText,{size:"xs",style:{marginTop:N.size.xxs}},(0,T.jsx)("strong",null,M.label))))))))},c=({pillarProps:M,pillarStats:D})=>(0,T.jsx)(j.EuiPanel,{hasBorder:!0,hasShadow:!1,paddingSize:"m"},(0,T.jsx)(j.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,T.jsx)(j.EuiFlexItem,{grow:6},(0,T.jsx)(x,{pillarProps:M,pillarStats:D})),(0,T.jsx)(j.EuiHorizontalRule,{margin:"m"}),(0,T.jsx)(j.EuiFlexItem,{grow:4},(0,T.jsx)(w,{pillarProps:M,pillarStats:D})))),t=()=>{const{pillarPropsMap:M}=a(),{readinessTasksStats:D}=y();return(0,T.jsx)(j.EuiFlexGroup,{direction:"row",gutterSize:"l",style:{height:240}},Object.values(M).map((M=>{const N=D.pillarStatsMap[M.pillarKey];return(0,T.jsx)(j.EuiFlexItem,{key:M.pillarKey},(0,T.jsx)(c,{pillarProps:M,pillarStats:N}))})))},l=({color:M=e,width:D=16,height:N=16})=>(0,T.jsx)("svg",{width:D,height:N,viewBox:"0 0 15 16",fill:"none",xmlns:"http://www.w3.org/2000/svg",style:{color:M}},(0,T.jsx)("svg",{width:"15",height:"16",viewBox:"0 0 15 16",fill:"none",xmlns:"http://www.w3.org/2000/svg"},(0,T.jsx)("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M7.56108 1.14412L12.9756 2.28524C13.112 2.31384 13.2095 2.43411 13.2095 2.57419V8.13605C13.2095 9.62186 12.6052 11.1488 11.5081 12.4344C10.4454 13.6789 9.00661 14.5649 7.55969 14.864C7.53988 14.8676 7.52008 14.8698 7.50028 14.8698C7.48048 14.8698 7.45995 14.8676 7.44015 14.864C5.99395 14.5648 4.55436 13.6789 3.49249 12.4344C2.39537 11.1488 1.79108 9.6226 1.79108 8.13605V2.57419C1.79108 2.43485 1.88862 2.31458 2.02503 2.28524L7.43951 1.14412C7.47911 1.13606 7.52074 1.13606 7.56108 1.14412ZM12.619 2.814L7.50006 1.73521L2.38108 2.814V8.13611C2.38108 10.8694 4.71904 13.6649 7.50006 14.273C10.2809 13.6651 12.619 10.8694 12.619 8.13611V2.814ZM10.248 4.86226L6.51441 8.59589L4.75213 6.83361C4.637 6.71847 4.44998 6.71847 4.33484 6.83361C4.2197 6.94875 4.2197 7.13576 4.33484 7.25091L6.30613 9.2222C6.36114 9.2772 6.43667 9.30874 6.51515 9.30874C6.59362 9.30874 6.66842 9.27793 6.72416 9.2222L10.666 5.28036C10.7811 5.16523 10.7811 4.97821 10.666 4.86307C10.5501 4.7472 10.3632 4.74712 10.248 4.86226ZM14.316 8.13611V1.43672L7.50006 6.10352e-05L0.684082 1.43672V8.13611C0.684082 11.8052 3.80098 15.395 7.50006 16.0001C11.1991 15.395 14.316 11.8052 14.316 8.13611Z",fill:"currentColor"}),(0,T.jsx)("path",{d:"M10.248 4.86226L6.51441 8.59589L4.75213 6.83361C4.637 6.71847 4.44998 6.71847 4.33484 6.83361C4.2197 6.94875 4.2197 7.13576 4.33484 7.25091L6.30613 9.2222C6.36114 9.2772 6.43667 9.30874 6.51515 9.30874C6.59362 9.30874 6.66842 9.27793 6.72416 9.2222L10.666 5.28036C10.7811 5.16523 10.7811 4.97821 10.666 4.86307C10.5501 4.7472 10.3632 4.74712 10.248 4.86226Z",fill:"white"}),(0,T.jsx)("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M7.56108 1.14412L12.9756 2.28524C13.112 2.31384 13.2095 2.43411 13.2095 2.57419V8.13605C13.2095 9.62186 12.6052 11.1488 11.5081 12.4344C10.4454 13.6789 9.00661 14.5649 7.55969 14.864C7.53988 14.8676 7.52008 14.8698 7.50028 14.8698C7.48048 14.8698 7.45995 14.8676 7.44015 14.864C5.99395 14.5648 4.55436 13.6789 3.49249 12.4344C2.39537 11.1488 1.79108 9.6226 1.79108 8.13605V2.57419C1.79108 2.43485 1.88862 2.31458 2.02503 2.28524L7.43951 1.14412C7.47911 1.13606 7.52074 1.13606 7.56108 1.14412ZM7.50006 1.73521L12.619 2.814V8.13611C12.619 10.8694 10.2809 13.6651 7.50006 14.273C4.71904 13.6649 2.38108 10.8694 2.38108 8.13611V2.814L7.50006 1.73521Z",fill:"white"})));var S=N(57064),s=N.n(S),E={name:"1d3w5wq",styles:"width:100%"},o={name:"umwchj",styles:"overflow-y:auto"};const C=()=>{const[M,D]=s()("readiness-tasks-selected-pillar",""),[N,g]=s()("readiness-tasks-status-filter",null),{pillarPropsMap:A}=a(),{euiTheme:O}=(0,j.useEuiTheme)(),{logReadinessTask:u,getLatestTasks:k}=L(),y=(0,I.useCallback)((async M=>{u(M)}),[u]),e=(0,I.useMemo)((()=>[{value:"",inputDisplay:i.i18n.translate("xpack.securitySolution.siemReadiness.allCategoriesOption",{defaultMessage:"All Categories"})},...Object.values(A).map((M=>({value:M.pillarKey,inputDisplay:M.displayName})))]),[A]),x=(0,I.useMemo)((()=>z.filter((D=>!M||D.pillar===M)).filter((M=>{var D;const I=null===(D=k.data)||void 0===D?void 0:D.find((D=>D.task_id===M.id));return"completed"===N?"completed"===(null==I?void 0:I.status):"incomplete"!==N||"completed"!==(null==I?void 0:I.status)})).sort(((M,D)=>M.order-D.order))),[M,N,k.data]),w=(0,I.useMemo)((()=>{const D=z.filter((D=>!M||D.pillar===M)),N=D.filter((M=>{var D;const N=null===(D=k.data)||void 0===D?void 0:D.find((D=>D.task_id===M.id));return"completed"===(null==N?void 0:N.status)})).length;return{completed:N,incomplete:D.length-N}}),[M,k.data]),c=(0,I.useMemo)((()=>({"lets-get-started":{action:()=>y({task_id:"lets-get-started",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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",learnMoreLink:"https://www.elastic.co/security-readiness"},"enable-endpoint-visibility":{action:()=>y({task_id:"enable-endpoint-visibility",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"ingest-cloud-audit-logs":{action:()=>y({task_id:"ingest-cloud-audit-logs",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"ingest-asset-inventory":{action:()=>y({task_id:"ingest-asset-inventory",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"enable-kubernetes-container-logs":{action:()=>y({task_id:"enable-kubernetes-container-logs",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"ingest-all-cloud-logs-inventory":{action:()=>y({task_id:"ingest-all-cloud-logs-inventory",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTI4IiBoZWlnaHQ9IjEyOCIgdmlld0JveD0iMCAwIDEyOCAxMjgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIxMjgiIGhlaWdodD0iMTI4IiAvPgo8cGF0aCBkPSJNNDMuNDEwMiA1Ny40NlY4NC42N0w1MS4yMjAyIDkyLjdWMTA1LjI1IiBzdHJva2U9IiMxNTMzODUiIHN0cm9rZS1taXRlcmxpbWl0PSIxMCIvPgo8cGF0aCBkPSJNNTEuMjIwMyAxMTIuNkM1My4zODAzIDExMi42IDU1LjEyMDMgMTEwLjg1IDU1LjEyMDMgMTA4LjdDNTUuMTIwMyAxMDYuNTUgNTMuMzcwMyAxMDQuOCA1MS4yMjAzIDEwNC44QzQ5LjA3MDMgMTA0LjggNDcuMzIwMyAxMDYuNTUgNDcuMzIwMyAxMDguN0M0Ny4zMjAzIDExMC44NSA0OS4wNzAzIDExMi42IDUxLjIyMDMgMTEyLjZaIiBmaWxsPSIjNDhFRkNGIiBzdHJva2U9IiMxMDFDM0YiIHN0cm9rZS1taXRlcmxpbWl0PSIxMCIvPgo8cGF0aCBkPSJNMjEuMjEwMiA1My43OTk4VjczLjM0OThMMTMuNDAwMiA4MS4zNjk4TDEzLjE2MDIgODcuNDM5OCIgc3Ryb2tlPSIjMTUzMzg1IiBzdHJva2UtbWl0ZXJsaW1pdD0iMTAiLz4KPHBhdGggZD0iTTEzLjE1IDk0Ljc5MDJDMTUuMzEgOTQuNzkwMiAxNy4wNSA5My4wNDAyIDE3LjA1IDkwLjg5MDJDMTcuMDUgODguNzQwMiAxNS4zIDg2Ljk5MDIgMTMuMTUgODYuOTkwMkMxMSA4Ni45OTAyIDkuMjUgODguNzQwMiA5LjI1IDkwLjg5MDJDOS4yNSA5My4wNDAyIDExIDk0Ljc5MDIgMTMuMTUgOTQuNzkwMloiIGZpbGw9IiM0OEVGQ0YiIHN0cm9rZT0iIzEwMUMzRiIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIi8+CjxwYXRoIGQ9Ik0zMi4xMDAyIDk5LjA1OThDMzQuMjYwMiA5OS4wNTk4IDM2LjAwMDIgOTcuMzA5OCAzNi4wMDAyIDk1LjE1OThDMzYuMDAwMiA5My4wMDk4IDM0LjI1MDIgOTEuMjU5OCAzMi4xMDAyIDkxLjI1OThDMjkuOTUwMiA5MS4yNTk4IDI4LjIwMDIgOTMuMDA5OCAyOC4yMDAyIDk1LjE1OThDMjguMjAwMiA5Ny4zMDk4IDI5Ljk1MDIgOTkuMDU5OCAzMi4xMDAyIDk5LjA1OThaIiBmaWxsPSIjNDhFRkNGIiBzdHJva2U9IiMxMDFDM0YiIHN0cm9rZS1taXRlcmxpbWl0PSIxMCIvPgo8cGF0aCBkPSJNMzIuMDk5NiA2MC41MDk4VjkxLjczOTgiIHN0cm9rZT0iIzE1MzM4NSIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIi8+CjxwYXRoIGQ9Ik04NC4xOCAyNS40NEM4Mi43MSAyNS40NCA4MS4yNyAyNS41NSA3OS44NiAyNS43NUM3NS4yOSAxOC45NiA2Ny41NCAxNC41IDU4Ljc1IDE0LjVDNDcuNjQgMTQuNSAzOC4xOSAyMS42MyAzNC43MyAzMS41NkMzMy4xMyAzMS4xOCAzMS40NiAzMC45NyAyOS43NCAzMC45N0MxOC4wMSAzMC45NyA4LjUgNDAuNDggOC41IDUyLjIyQzguNSA1NC42MSA4LjkgNTYuOTEgOS42MyA1OS4wNUgxMTQuMzlDMTE0LjUgNTcuOTkgMTE0LjU2IDU2LjkxIDExNC41NiA1NS44MUMxMTQuNTYgMzkuMDMgMTAwLjk2IDI1LjQzIDg0LjE4IDI1LjQzVjI1LjQ0WiIgZmlsbD0iIzE1MzM4NSIgc3Ryb2tlPSIjMTAxQzNGIiBzdHJva2UtbWl0ZXJsaW1pdD0iMTAiLz4KPHBhdGggZD0iTTg0LjE4IDMwLjI2MDNDODIuNzEgMzAuMjYwMyA4MS4yNyAzMC4zNzAzIDc5Ljg2IDMwLjU3MDNDNzUuMjkgMjMuNzkwMyA2Ny41NCAxOS4zMjAzIDU4Ljc1IDE5LjMyMDNDNDcuNjQgMTkuMzIwMyAzOC4xOSAyNi40NTAzIDM0LjczIDM2LjM4MDNDMzMuMTMgMzYuMDAwMyAzMS40NiAzNS43OTAzIDI5Ljc0IDM1Ljc5MDNDMTguMDEgMzUuNzkwMyA4LjUgNDUuMzAwMyA4LjUgNTcuMDQwM0M4LjUgNTkuNDMwMyA4LjkgNjEuNzMwMyA5LjYzIDYzLjg3MDNIMTE0LjM5QzExNC41IDYyLjgxMDMgMTE0LjU2IDYxLjczMDMgMTE0LjU2IDYwLjYzMDNDMTE0LjU2IDQzLjg1MDMgMTAwLjk2IDMwLjI1MDMgODQuMTggMzAuMjUwM1YzMC4yNjAzWiIgZmlsbD0id2hpdGUiIHN0cm9rZT0iIzEwMUMzRiIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIi8+CjxwYXRoIGQ9Ik04NS4wMTk2IDk3Ljk3OTNDODMuMjk5NiA5Ny4zMzkzIDgzLjUyOTYgOTUuNjY5MyA4My41Mjk2IDk1LjY2OTNMOTEuNjg5NyA4My45NjkzTDEwNi4yMiA2OC4wMjkzTDEwOC42OCA3MS4xNDkzTDExNi4xNSA2Ny40NDkzTDExMi45MiA1Ni43NzkzTDExNi4yMyA2Mi4xMjkzTDExOC43MyA3Mi4yMTkzTDExMS4xNiA3Ni4xMzkzQzExMC4zMyA3OS4zNTkzIDEwNy41NiA4Ny4zMjkzIDk5Ljg0OTYgOTIuODU5M0wxMDEuNzYgOTMuOTE5M0wxMTAuNzYgODMuOTc5M0wxMTMuODcgODguNjc5M0wxMDQuMzcgOTguMTg5M0w5Ny45OTk2IDk0LjM4OTNMOTcuODU5NiA5NC4xNzkzQzk3LjE1OTYgOTQuNTk5MyA5Ni40Mzk2IDk0Ljk5OTMgOTUuNjY5NiA5NS4zNjkzQzkzLjM4OTYgOTYuNDY5MyA5MS41NDk3IDk3LjE3OTMgOTAuMDM5NiA5Ny42MTkzTDg3LjEwOTYgMTA0LjY5OUw3NS4wODk2IDEwNC4xNzlMNzEuNjM5NiA5OS4zNTkzTDgzLjkzOTcgMTAwLjQxOUw4NS4wMDk3IDk3Ljk3OTNIODUuMDE5NloiIGZpbGw9IiMxNTMzODUiIHN0cm9rZT0iIzEwMUMzRiIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTAwLjU3IDQ3LjIyOTVMMTAzLjcxIDUyLjcwOTVMMTAyLjQ4IDU3Ljc0OTVMOTguNTgwMSA1NS40MTk1TDEwMC41NyA0Ny4yMjk1WiIgZmlsbD0iIzE1MzM4NSIgc3Ryb2tlPSIjMTAxQzNGIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik01OS42Nzk5IDg5LjgyOTZMNzAuMTA5OSA4NS41NTk2TDc0LjM0OTkgOTAuMTg5Nkw3My44NDk5IDkwLjM3OTZMNzUuMzQ5OSA5MS4yNzk2TDczLjc4OTkgOTMuODg5Nkw3Mi43OTk5IDkzLjc3OTZDNzIuNzk5OSA5My43Nzk2IDcxLjcwOTkgOTMuMDg5NiA3MC41MTk5IDkxLjYxOTZMNjIuNTI5OSA5NC41OTk2TDU5LjY2OTkgODkuODI5Nkg1OS42Nzk5WiIgZmlsbD0iIzE1MzM4NSIgc3Ryb2tlPSIjMTAxQzNGIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04My4yMDk5IDcyLjM1OTNDNzYuNTk5OSA3OC43MzkzIDc5LjY0OTkgODQuMDQ5MyA3OS42NDk5IDg0LjA0OTNMNjcuOTE5OSA3OC40MjkzTDg0LjgzOTkgNTguODE5M0w5OC42MTk5IDY2LjI0OTNMOTcuMDY5OSA3MS4zMDkzQzk3LjA2OTkgNzEuMzA5MyA4OS44MTk5IDY1Ljk4OTMgODMuMjA5OSA3Mi4zNTkzWiIgZmlsbD0iIzE1MzM4NSIgc3Ryb2tlPSIjMTAxQzNGIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik02NC43MTAyIDc0LjY2OTlMNTYuNDEwMiA3OS4xNjk5TDU5LjY3MDIgODkuODI5OUw2OC4wNzAyIDg2LjkyOTlDNjkuNDMwMiA4OC44NDk5IDcxLjE1MDIgOTAuNTQ5OSA3My4xODAyIDkxLjk0OTlMNzEuNjQwMiA5OS4zNTk5TDgzLjk0MDIgMTAwLjQyTDg2LjcwMDIgOTQuMTM5OUM4OS42NjAyIDkzLjQ0OTkgOTIuNjIwMiA5Mi4xMzk5IDk1LjM1MDIgOTAuMzU5OUwxMDEuNzYgOTMuOTE5OUwxMTAuNzYgODMuOTc5OUwxMDUuNzQgNzguNTY5OUMxMDYuNzcgNzYuMjY5OSAxMDcuMzMgNzMuOTY5OSAxMDcuNDkgNzEuNzI5OUwxMTYuMTQgNjcuNDQ5OUwxMTIuOTEgNTYuNzc5OUwxMDMuOTkgNTkuNjA5OUMxMDIuNjEgNTcuNjk5OSAxMDAuODggNTYuMDA5OSA5OC44NTAyIDU0LjYxOTlMMTAwLjU1IDQ3LjIyOTlMODguMTQwMiA0Ni4xNjk5TDg1Ljc4MDIgNTIuNTM5OUM4Mi41OTAyIDUzLjI1OTkgNzkuMzcwMiA1NC42ODk5IDc2LjQzMDIgNTYuNjU5OUw3MC42NTAyIDUzLjIwOTlMNjEuNTcwMiA2Mi44Mzk5TDY2LjU4MDIgNjcuNzQ5OUM2NS40ODAyIDcwLjA3OTkgNjQuODkwMiA3Mi4zOTk5IDY0LjY5MDIgNzQuNjY5OUg2NC43MTAyWk04MC44MTAyIDY2LjkyOTlDODUuNDkwMiA2My42MDk5IDkxLjQ5MDIgNjQuMDE5OSA5NC4yMTAyIDY3Ljg0OTlDOTYuOTMwMiA3MS42Nzk5IDk1LjM0MDIgNzcuNDc5OSA5MC42NjAyIDgwLjc5OTlDODUuOTgwMiA4NC4xMTk5IDc5Ljk4MDIgODMuNzA5OSA3Ny4yNjAyIDc5Ljg3OTlDNzQuNTQwMiA3Ni4wNDk5IDc2LjEzMDIgNzAuMjQ5OSA4MC44MTAyIDY2LjkyOTlaIiBmaWxsPSIjMEI2NEREIiBzdHJva2U9IiMxMDFDM0YiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+Cg=="},"enable-mitre-aligned-detection-rules":{action:()=>y({task_id:"enable-mitre-aligned-detection-rules",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"view-detection-coverage-mitre":{action:()=>y({task_id:"view-detection-coverage-mitre",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"add-threat-intel-feeds":{action:()=>y({task_id:"add-threat-intel-feeds",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"customize-create-rules":{action:()=>y({task_id:"customize-create-rules",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"use-attack-discovery":{action:()=>y({task_id:"use-attack-discovery",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"maintain-rule-coverage":{action:()=>y({task_id:"maintain-rule-coverage",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"enable-cspm-on-all-clouds":{action:()=>y({task_id:"enable-cspm-on-all-clouds",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"investigate-alert-using-timeline":{action:()=>y({task_id:"investigate-alert-using-timeline",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"use-ai-assistant-for-alert-root-cause":{action:()=>y({task_id:"use-ai-assistant-for-alert-root-cause",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"add-external-connectors":{action:()=>y({task_id:"add-external-connectors",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"automate-response-rules-case-creation":{action:()=>y({task_id:"automate-response-rules-case-creation",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"create-manage-case-workflows":{action:()=>y({task_id:"create-manage-case-workflows",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"},"complete-automated-cases":{action:()=>y({task_id:"complete-automated-cases",status:"completed"}),actionButtonLabel:"Complete Task",illustration:"data:image/svg+xml;base64,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"}})),[y]),t=(0,I.useMemo)((()=>[{key:"incomplete",label:i.i18n.translate("xpack.securitySolution.siemReadiness.incompleteFilter",{defaultMessage:"Incomplete"}),count:w.incomplete,isActive:"incomplete"===N,onClick:()=>{g("incomplete"===N?null:"incomplete")},withNext:!0},{key:"completed",label:i.i18n.translate("xpack.securitySolution.siemReadiness.completeFilter",{defaultMessage:"Complete"}),count:w.completed,isActive:"completed"===N,onClick:()=>{g("completed"===N?null:"completed")},withNext:!1}]),[N,w.completed,w.incomplete,g]),l=i.i18n.translate("xpack.securitySolution.siemReadiness.categoriesPlaceholder",{defaultMessage:"Categories"});return(0,T.jsx)(j.EuiSplitPanel.Outer,{hasBorder:!0,hasShadow:!1,css:(0,T.css)({height:600},"","")},(0,T.jsx)(j.EuiSplitPanel.Inner,{grow:!1,css:E},(0,T.jsx)(j.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},(0,T.jsx)(j.EuiFlexItem,null,(0,T.jsx)(j.EuiTitle,{size:"s"},(0,T.jsx)("h3",null,i.i18n.translate("xpack.securitySolution.siemReadiness.tasksTitle",{defaultMessage:"Tasks"})))),(0,T.jsx)(j.EuiFlexItem,{grow:!1},(0,T.jsx)(j.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},(0,T.jsx)(j.EuiFlexItem,{grow:!1},(0,T.jsx)(j.EuiFilterGroup,null,t.map((M=>(0,T.jsx)(j.EuiFilterButton,{key:M.key,withNext:M.withNext,hasActiveFilters:M.isActive,isSelected:M.isActive,onClick:M.onClick,isToggle:!0,"data-test-subj":`${M.key}FilterButton`},(0,T.jsx)(j.EuiFlexGroup,{gutterSize:"xs",alignItems:"center"},(0,T.jsx)(j.EuiFlexItem,{grow:!1},M.label),(0,T.jsx)(j.EuiFlexItem,{grow:!1},(0,T.jsx)(j.EuiNotificationBadge,{color:"subdued"},M.count)))))))),(0,T.jsx)(j.EuiFlexItem,{grow:!1},(0,T.jsx)(j.EuiSuperSelect,{css:(0,T.css)({width:150},"",""),options:e,valueOfSelected:M,onChange:M=>D(M),placeholder:l,"aria-label":l})))))),(0,T.jsx)(j.EuiSplitPanel.Inner,{grow:!0,color:"subdued",css:o},x.map((M=>{var D;const N=c[M.id]||{},I=null===(D=k.data)||void 0===D?void 0:D.find((D=>D.task_id===M.id)),g=A[M.pillar];return(0,T.jsx)(j.EuiAccordion,{css:(0,T.css)({backgroundColor:O.colors.plainLight,margin:`${O.size.m} 0`,paddingRight:O.size.s},"",""),borders:"all",key:M.id,id:M.id,arrowDisplay:"right",buttonContent:(0,T.jsx)(j.EuiFlexGroup,{alignItems:"center",justifyContent:"spaceBetween",gutterSize:"s"},(0,T.jsx)(j.EuiFlexItem,null,(0,T.jsx)("div",{style:{display:"flex",alignItems:"center"}},(0,T.jsx)("span",{style:{marginRight:O.size.s,fontWeight:O.font.weight.bold}},i.i18n.translate("xpack.securitySolution.siemReadiness.categoryLabel",{defaultMessage:"Category:"})),(null==g?void 0:g.icon)&&(0,T.jsx)(j.EuiIcon,{type:g.icon,size:"m",color:g.color,css:(0,T.css)({marginRight:O.size.s},"","")}),(0,T.jsx)("span",{style:{marginRight:O.size.m}},null==g?void 0:g.displayName),(0,T.jsx)("span",{style:{fontWeight:O.font.weight.bold,marginRight:O.size.s}},i.i18n.translate("xpack.securitySolution.siemReadiness.taskLabel",{defaultMessage:"Task:"})),(0,T.jsx)("span",null,`${M.taskNumber}. ${M.title}`)))),paddingSize:"l",initialIsOpen:!1,buttonProps:{paddingSize:"m"},style:{borderRadius:O.border.radius.medium},extraAction:(0,T.jsx)("div",{style:{paddingRight:O.size.base}},(0,T.jsx)(j.EuiBadge,{color:"completed"===(null==I?void 0:I.status)?"#4DD2CA":"#FDE9B5"},"completed"===(null==I?void 0:I.status)?i.i18n.translate("xpack.securitySolution.siemReadiness.completedStatus",{defaultMessage:"Completed"}):i.i18n.translate("xpack.securitySolution.siemReadiness.incompleteStatus",{defaultMessage:"Incomplete"})))},(0,T.jsx)(j.EuiFlexGroup,null,(0,T.jsx)(j.EuiFlexItem,null,(0,T.jsx)(j.EuiFlexGroup,{direction:"column"},(0,T.jsx)(j.EuiFlexItem,null,(0,T.jsx)(j.EuiText,{size:"s"},(0,T.jsx)("p",{style:{whiteSpace:"pre-wrap"}},M.description))),(0,T.jsx)(j.EuiFlexItem,{style:{justifyContent:"flex-start",alignItems:"flex-end",flexDirection:"row",gap:O.size.s}},N.actionButtonLabel&&N.action&&(0,T.jsx)(j.EuiButton,{size:"s",fill:!0,onClick:()=>{var M;return null===(M=N.action)||void 0===M?void 0:M.call(N)},disabled:"completed"===(null==I?void 0:I.status)},N.actionButtonLabel),N.learnMoreLink&&(0,T.jsx)(j.EuiButtonEmpty,{iconType:"popout",size:"s",onClick:()=>window.open(N.learnMoreLink,"_blank")},i.i18n.translate("xpack.securitySolution.siemReadiness.learnMoreButton",{defaultMessage:"Learn More"}))))),(0,T.jsx)(j.EuiFlexItem,{grow:!1,css:(0,T.css)({width:128},"","")},(0,T.jsx)(j.EuiIcon,{type:N.illustration,css:(0,T.css)({width:128,height:128},"","")}))))}))))};var U=N(43059),d=N(75879);const Q=()=>{const{readinessTasksStats:M}=y(),{pillarPropsMap:D}=a(),{euiTheme:N}=(0,j.useEuiTheme)(),I=Object.entries(M.pillarStatsMap).map((([M,D])=>({pillarKey:M,completedTasksCount:D.completed})));return I.push({pillarKey:"incomplete",completedTasksCount:M.totalIncomplete}),(0,T.jsx)("div",{style:{position:"relative",width:200}},(0,T.jsx)(U.Chart,{size:{height:200}},(0,T.jsx)(U.Settings,{theme:{partition:{emptySizeRatio:.7,linkLabel:{maximumSection:1/0,maxCount:0}}},ariaLabelledBy:"siem-readiness-pie-chart"}),(0,T.jsx)(U.Partition,{id:"pillarDonut",data:I,layout:U.PartitionLayout.sunburst,valueAccessor:M=>M.completedTasksCount,layers:[{groupByRollup:M=>M.pillarKey,nodeLabel:M=>"incomplete"===M?i.i18n.translate("xpack.securitySolution.siemReadiness.incompleteTasksLabel",{defaultMessage:"Incomplete"}):D[M].displayName,shape:{fillColor:M=>"incomplete"===M?N.colors.lightShade:D[M].color}}]})),(0,T.jsx)("div",{style:{display:"flex",flexDirection:"column",justifyContent:"center",gap:N.size.xs,position:"absolute",inset:"25%",height:"50%",width:"50%"}},(0,T.jsx)(j.EuiTitle,{className:"eui-textCenter",size:"m"},(0,T.jsx)("h1",{style:{fontWeight:700}},`${M.totalCompleted}/${M.totalTasks}`)),(0,T.jsx)(j.EuiTitle,{className:"eui-textCenter",size:"xxs"},(0,T.jsx)("h3",null,i.i18n.translate("xpack.securitySolution.siemReadiness.totalTaskCompletionScore",{defaultMessage:"Total task completion score"})))))};var Y={name:"kcl2ql",styles:"& *{border-block:none !important;}"};const n=()=>{const{readinessTasksStats:M}=y(),{pillarPropsMap:D}=a(),N=Object.entries(M.pillarStatsMap).map((([M,N])=>({pillarKey:M,pillarName:D[M].displayName,...N}))),I=[{field:"pillarName",name:i.i18n.translate("xpack.securitySolution.siemReadiness.readinessSectionColumnName",{defaultMessage:"Readiness Section"}),render:(M,N)=>(0,T.jsx)(j.EuiHealth,{color:D[N.pillarKey].color},M)},{field:"score",name:i.i18n.translate("xpack.securitySolution.siemReadiness.taskScoreColumnName",{defaultMessage:"Task Score"}),render:(M,D)=>`${D.completed}/${D.total}`}];return(0,T.jsx)(j.EuiBasicTable,{tableCaption:i.i18n.translate("xpack.securitySolution.siemReadiness.pillarTaskCompletionSummaryCaption",{defaultMessage:"Pillar Task Completion Summary"}),items:N,columns:I,compressed:!0,css:Y})},r=()=>(0,T.jsx)("div",null,(0,T.jsx)(j.EuiTitle,{size:"xs"},(0,T.jsx)("h4",null,(0,T.jsx)(d.FormattedMessage,{id:"xpack.securitySolution.siemReadiness.aboutSiemReadinessTitle",defaultMessage:"About SIEM Readiness"}))),(0,T.jsx)(j.EuiText,{size:"s"},(0,T.jsx)("p",null,(0,T.jsx)(d.FormattedMessage,{id:"xpack.securitySolution.siemReadiness.aboutSiemReadinessDescription1",defaultMessage:"SIEM Readiness shows how prepared your organization is to defend against threats, built on three pillars: {visibility} (data coverage), {detection} (threat rules), and {response} (ability to act).",values:{visibility:(0,T.jsx)("strong",null,"Visibility"),detection:(0,T.jsx)("strong",null,"Detection"),response:(0,T.jsx)("strong",null,"Response")}})),(0,T.jsx)("p",null,(0,T.jsx)(d.FormattedMessage,{id:"xpack.securitySolution.siemReadiness.aboutSiemReadinessDescription2",defaultMessage:"This page highlights gaps and turns them into clear tasks. Completing these tasks improves your readiness score and strengthens your security posture. Use the task list to focus on what matters—like enabling logs, deploying endpoint protection, or activating detection rules. Learn more in our {docsLink}.",values:{docsLink:(0,T.jsx)(j.EuiLink,{href:"https://www.elastic.co/guide/index.html",target:"_blank",external:!0},"docs")}}))));var m={name:"o9o80q",styles:"align-self:center;max-width:330px"};const b=()=>{const{euiTheme:M}=(0,j.useEuiTheme)();return(0,T.jsx)(j.EuiPanel,{hasBorder:!0,css:(0,T.css)({padding:`${M.size.l} ${M.size.xxl}`},"","")},(0,T.jsx)(j.EuiFlexGroup,null,(0,T.jsx)(j.EuiFlexItem,{grow:!1,css:(0,T.css)({marginRight:M.size.xxl},"","")},(0,T.jsx)(Q,null)),(0,T.jsx)(j.EuiFlexItem,{grow:3,css:m},(0,T.jsx)(n,null)),(0,T.jsx)(j.EuiFlexItem,{grow:7},(0,T.jsx)(r,null))))},p=()=>(0,T.jsx)("div",null,(0,T.jsx)(j.EuiPageHeader,{pageTitle:i.i18n.translate("xpack.securitySolution.siemReadiness.pageTitle",{defaultMessage:"SIEM Readiness"}),bottomBorder:!0}),(0,T.jsx)(j.EuiPageSection,null,(0,T.jsx)(b,null)),(0,T.jsx)(j.EuiPageSection,{contentProps:{style:{paddingBlock:"0"}}},(0,T.jsx)(t,null)),(0,T.jsx)(j.EuiPageSection,null,(0,T.jsx)(C,null)));p.displayName="SiemReadinessDashboard";const G=p}}]);