"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestContextFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _saved_objects = require("@kbn/entityManager-plugin/server/saved_objects");
var _monitoring_entity_source_data_client = require("./lib/entity_analytics/privilege_monitoring/data_sources/monitoring_entity_source_data_client");
var _pad_package_installation_client = require("./lib/entity_analytics/privilege_monitoring/privileged_access_detection/pad_package_installation_client");
var _constants = require("../common/constants");
var _client = require("./client");
var _asset_inventory_data_client = require("./lib/asset_inventory/asset_inventory_data_client");
var _detection_rules_client = require("./lib/detection_engine/rule_management/logic/detection_rules_client/detection_rules_client");
var _asset_criticality = require("./lib/entity_analytics/asset_criticality");
var _entity_store_data_client = require("./lib/entity_analytics/entity_store/entity_store_data_client");
var _risk_engine_data_client = require("./lib/entity_analytics/risk_engine/risk_engine_data_client");
var _risk_score_data_client = require("./lib/entity_analytics/risk_score/risk_score_data_client");
var _authz = require("./lib/machine_learning/authz");
var _common = require("./lib/timeline/utils/common");
var _data_client = require("./lib/entity_analytics/privilege_monitoring/engine/data_client");
var _api_key = require("./lib/entity_analytics/privilege_monitoring/auth/api_key");
var _api_key2 = require("./lib/entity_analytics/entity_store/auth/api_key");
var _saved_objects2 = require("./lib/entity_analytics/privilege_monitoring/saved_objects");
var _siem_migrations = require("./lib/siem_migrations");
var _entity_store_crud_client = require("./lib/entity_analytics/entity_store/entity_store_crud_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RequestContextFactory {
  constructor(options) {
    (0, _defineProperty2.default)(this, "appClientFactory", void 0);
    this.options = options;
    this.appClientFactory = new _client.AppClientFactory();
  }
  async create(context, request) {
    var _startPlugins$spaces2, _startPlugins$spaces3, _startPlugins$fleet;
    const {
      options,
      appClientFactory
    } = this;
    const {
      config,
      core,
      plugins,
      endpointAppContextService,
      ruleMonitoringService,
      siemMigrationsService,
      productFeaturesService
    } = options;
    const {
      lists,
      ruleRegistry,
      security
    } = plugins;
    const [coreStart, startPlugins] = await core.getStartServices();
    const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, request);
    const coreContext = await context.core;
    const licensing = await context.licensing;
    const actionsClient = await startPlugins.actions.getActionsClientWithRequest(request);
    const dataViewsService = await startPlugins.dataViews.dataViewsServiceFactory(coreContext.savedObjects.client, coreContext.elasticsearch.client.asInternalUser, request);
    const getSpaceId = () => {
      var _startPlugins$spaces, _startPlugins$spaces$;
      return ((_startPlugins$spaces = startPlugins.spaces) === null || _startPlugins$spaces === void 0 ? void 0 : (_startPlugins$spaces$ = _startPlugins$spaces.spacesService) === null || _startPlugins$spaces$ === void 0 ? void 0 : _startPlugins$spaces$.getSpaceId(request)) || _constants.DEFAULT_SPACE_ID;
    };
    appClientFactory.setup({
      getSpaceId: (_startPlugins$spaces2 = startPlugins.spaces) === null || _startPlugins$spaces2 === void 0 ? void 0 : (_startPlugins$spaces3 = _startPlugins$spaces2.spacesService) === null || _startPlugins$spaces3 === void 0 ? void 0 : _startPlugins$spaces3.getSpaceId,
      config,
      kibanaVersion: options.kibanaVersion,
      kibanaBranch: options.kibanaBranch,
      buildFlavor: options.buildFlavor
    });
    const getAppClient = () => appClientFactory.create(request);
    const getAuditLogger = () => security === null || security === void 0 ? void 0 : security.audit.asScoped(request);
    const getEntityStoreApiKeyManager = () => (0, _api_key2.getApiKeyManager)({
      core: coreStart,
      logger: options.logger,
      security: startPlugins.security,
      encryptedSavedObjects: startPlugins.encryptedSavedObjects,
      request,
      namespace: getSpaceId()
    });
    const getPrivilegedUserMonitoringApiKeyManager = () => (0, _api_key.getApiKeyManager)({
      core: coreStart,
      logger: options.logger,
      security: startPlugins.security,
      encryptedSavedObjects: startPlugins.encryptedSavedObjects,
      request,
      namespace: getSpaceId()
    });
    const getEntityStoreDataClient = (0, _lodash.memoize)(() => {
      // why are we defining this here, but other places we do it inline?
      const clusterClient = coreContext.elasticsearch.client;
      const logger = options.logger;
      const soClient = coreContext.savedObjects.getClient({
        includedHiddenTypes: [_saved_objects.EntityDiscoveryApiKeyType.name]
      });
      return new _entity_store_data_client.EntityStoreDataClient({
        namespace: getSpaceId(),
        clusterClient,
        dataViewsService,
        appClient: getAppClient(),
        logger,
        soClient,
        taskManager: startPlugins.taskManager,
        auditLogger: getAuditLogger(),
        kibanaVersion: options.kibanaVersion,
        config: config.entityAnalytics.entityStore,
        experimentalFeatures: config.experimentalFeatures,
        telemetry: core.analytics,
        apiKeyManager: getEntityStoreApiKeyManager(),
        security: startPlugins.security,
        request,
        uiSettingsClient: coreContext.uiSettings.client,
        isServerless: options.buildFlavor === 'serverless'
      });
    });

    // List of endpoint authz for the current request's user. Will be initialized the first
    // time it is requested (see `getEndpointAuthz()` below)
    let endpointAuthz;
    const rulesClient = await startPlugins.alerting.getRulesClientWithRequest(request);
    return {
      core: coreContext,
      getAnalytics: () => core.analytics,
      getServerBasePath: () => core.http.basePath.serverBasePath,
      getEndpointAuthz: async () => {
        if (!endpointAuthz) {
          // eslint-disable-next-line require-atomic-updates
          endpointAuthz = await endpointAppContextService.getEndpointAuthz(request);
        }
        return endpointAuthz;
      },
      getEndpointService: () => endpointAppContextService,
      getConfig: () => config,
      getFrameworkRequest: () => frameworkRequest,
      getAppClient,
      getSpaceId,
      getRuleDataService: () => ruleRegistry.ruleDataService,
      getRacClient: startPlugins.ruleRegistry.getRacClientWithRequest,
      getAuditLogger,
      getDataViewsService: () => dataViewsService,
      getEntityStoreApiKeyManager,
      getPrivilegedUserMonitoringApiKeyManager,
      getProductFeatureService: () => productFeaturesService,
      getDetectionRulesClient: (0, _lodash.memoize)(() => {
        const mlAuthz = (0, _authz.buildMlAuthz)({
          license: licensing.license,
          ml: plugins.ml,
          request,
          savedObjectsClient: coreContext.savedObjects.client
        });
        return (0, _detection_rules_client.createDetectionRulesClient)({
          rulesClient,
          actionsClient,
          savedObjectsClient: coreContext.savedObjects.client,
          mlAuthz,
          productFeaturesService,
          license: licensing.license
        });
      }),
      getDetectionEngineHealthClient: (0, _lodash.memoize)(() => ruleMonitoringService.createDetectionEngineHealthClient({
        rulesClient,
        eventLogClient: startPlugins.eventLog.getClient(request),
        currentSpaceId: getSpaceId()
      })),
      getRuleExecutionLog: (0, _lodash.memoize)(() => ruleMonitoringService.createRuleExecutionLogClientForRoutes({
        savedObjectsClient: coreContext.savedObjects.client,
        eventLogClient: startPlugins.eventLog.getClient(request)
      })),
      siemMigrations: (0, _siem_migrations.getSiemMigrationClients)(siemMigrationsService, {
        request,
        currentUser: coreContext.security.authc.getCurrentUser(),
        spaceId: getSpaceId(),
        dependencies: {
          inferenceService: startPlugins.inference,
          rulesClient,
          actionsClient,
          savedObjectsClient: coreContext.savedObjects.client,
          packageService: (_startPlugins$fleet = startPlugins.fleet) === null || _startPlugins$fleet === void 0 ? void 0 : _startPlugins$fleet.packageService,
          telemetry: core.analytics
        }
      }),
      getInferenceClient: (0, _lodash.memoize)(() => startPlugins.inference.getClient({
        request
      })),
      getExceptionListClient: () => {
        var _coreContext$security;
        if (!lists) {
          return null;
        }
        const username = ((_coreContext$security = coreContext.security.authc.getCurrentUser()) === null || _coreContext$security === void 0 ? void 0 : _coreContext$security.username) || 'elastic';
        return lists.getExceptionListClient(coreContext.savedObjects.client, username);
      },
      getInternalFleetServices: (0, _lodash.memoize)(() => endpointAppContextService.getInternalFleetServices()),
      getRiskEngineDataClient: (0, _lodash.memoize)(() => new _risk_engine_data_client.RiskEngineDataClient({
        logger: options.logger,
        kibanaVersion: options.kibanaVersion,
        esClient: coreContext.elasticsearch.client.asCurrentUser,
        soClient: coreContext.savedObjects.client,
        namespace: getSpaceId(),
        auditLogger: getAuditLogger()
      })),
      getRiskScoreDataClient: (0, _lodash.memoize)(() => new _risk_score_data_client.RiskScoreDataClient({
        logger: options.logger,
        kibanaVersion: options.kibanaVersion,
        esClient: coreContext.elasticsearch.client.asCurrentUser,
        soClient: coreContext.savedObjects.client,
        namespace: getSpaceId()
      })),
      getAssetCriticalityDataClient: (0, _lodash.memoize)(() => new _asset_criticality.AssetCriticalityDataClient({
        logger: options.logger,
        esClient: coreContext.elasticsearch.client.asCurrentUser,
        namespace: getSpaceId(),
        auditLogger: getAuditLogger()
      })),
      getPrivilegeMonitoringDataClient: (0, _lodash.memoize)(() => {
        return new _data_client.PrivilegeMonitoringDataClient({
          logger: options.logger,
          clusterClient: coreContext.elasticsearch.client,
          namespace: getSpaceId(),
          savedObjects: coreStart.savedObjects,
          taskManager: startPlugins.taskManager,
          apiKeyManager: getPrivilegedUserMonitoringApiKeyManager(),
          auditLogger: coreStart.security.audit.asScoped(request),
          kibanaVersion: options.kibanaVersion,
          telemetry: core.analytics,
          experimentalFeatures: options.config.experimentalFeatures
        });
      }),
      getMonitoringEntitySourceDataClient: (0, _lodash.memoize)(() => {
        const soClient = coreContext.savedObjects.getClient({
          includedHiddenTypes: [_saved_objects2.monitoringEntitySourceType.name]
        });
        return new _monitoring_entity_source_data_client.MonitoringEntitySourceDataClient({
          logger: options.logger,
          clusterClient: coreContext.elasticsearch.client,
          namespace: getSpaceId(),
          soClient
        });
      }),
      getPadPackageInstallationClient: (0, _lodash.memoize)(() => {
        return new _pad_package_installation_client.PadPackageInstallationClient({
          clusterClient: coreContext.elasticsearch.client,
          soClient: coreContext.savedObjects.client,
          logger: options.logger,
          namespace: getSpaceId(),
          dataViewsService
        });
      }),
      getEntityStoreDataClient,
      getEntityStoreCrudClient: (0, _lodash.memoize)(() => {
        return new _entity_store_crud_client.EntityStoreCrudClient({
          clusterClient: coreContext.elasticsearch.client,
          namespace: getSpaceId(),
          logger: options.logger,
          dataClient: getEntityStoreDataClient()
        });
      }),
      getAssetInventoryClient: (0, _lodash.memoize)(() => new _asset_inventory_data_client.AssetInventoryDataClient({
        logger: options.logger,
        clusterClient: coreContext.elasticsearch.client,
        uiSettingsClient: coreContext.uiSettings.client,
        usageCollection: options.plugins.usageCollection,
        coreStartPromise: core.getStartServices()
      })),
      getMlAuthz: (0, _lodash.memoize)(() => {
        return (0, _authz.buildMlAuthz)({
          license: licensing.license,
          ml: plugins.ml,
          request,
          savedObjectsClient: coreContext.savedObjects.client
        });
      })
    };
  }
}
exports.RequestContextFactory = RequestContextFactory;