"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleMigrationAgent = getRuleMigrationAgent;
exports.toolRouter = toolRouter;
var _langgraph = require("@langchain/langgraph");
var _prebuilt = require("@langchain/langgraph/prebuilt");
var _create_semantic_query = require("./nodes/create_semantic_query");
var _match_prebuilt_rule = require("./nodes/match_prebuilt_rule");
var _state2 = require("./state");
var _translate_rule = require("./sub_graphs/translate_rule");
var _resolve_dependencies = require("./nodes/resolve_dependencies_node/resolve_dependencies");
var _vendor_edge = require("./edges/vendor_edge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRuleMigrationAgent({
  model,
  esqlKnowledgeBase,
  ruleMigrationsRetriever,
  logger,
  telemetryClient,
  tools
}) {
  const matchPrebuiltRuleNode = (0, _match_prebuilt_rule.getMatchPrebuiltRuleNode)({
    model,
    logger,
    ruleMigrationsRetriever,
    telemetryClient
  });
  const resolveDepsToolNode = new _prebuilt.ToolNode([tools.getRulesByName]);
  const translationSubGraph = (0, _translate_rule.getTranslateRuleGraph)({
    model,
    esqlKnowledgeBase,
    ruleMigrationsRetriever,
    telemetryClient,
    logger
  });
  const resolveDependenciesNode = (0, _resolve_dependencies.getResolveDepsNode)({
    model
  });
  const createSemanticQueryNode = (0, _create_semantic_query.getCreateSemanticQueryNode)({
    model
  });
  const siemMigrationAgentGraph = new _langgraph.StateGraph(_state2.migrateRuleState, _state2.migrateRuleConfigSchema)
  // Nodes
  .addNode('resolveDependencies', resolveDependenciesNode).addNode('createSemanticQuery', createSemanticQueryNode).addNode('resolveDepsTools', resolveDepsToolNode).addNode('matchPrebuiltRule', matchPrebuiltRuleNode).addNode('translationSubGraph', translationSubGraph)
  // Edges
  .addConditionalEdges(_langgraph.START, (0, _vendor_edge.getVendorRouter)('qradar'), {
    is_qradar: 'resolveDependencies',
    is_not_qradar: 'createSemanticQuery'
  })
  // .addEdge(START, 'createSemanticQuery')
  .addConditionalEdges('resolveDependencies', toolRouter, {
    hasToolCalls: 'resolveDepsTools',
    noToolCalls: 'createSemanticQuery'
  }).addEdge('resolveDepsTools', 'resolveDependencies').addConditionalEdges('createSemanticQuery', skipPrebuiltRuleConditional, ['matchPrebuiltRule', 'translationSubGraph']).addConditionalEdges('matchPrebuiltRule', matchedPrebuiltRuleConditional, ['translationSubGraph', _langgraph.END]).addEdge('translationSubGraph', _langgraph.END);
  const graph = siemMigrationAgentGraph.compile();
  graph.name = 'Rule Migration Graph'; // Customizes the name displayed in LangSmith
  return graph;
}
const skipPrebuiltRuleConditional = (_state, config) => {
  var _config$configurable;
  if ((_config$configurable = config.configurable) !== null && _config$configurable !== void 0 && _config$configurable.skipPrebuiltRulesMatching) {
    return 'translationSubGraph';
  }
  return 'matchPrebuiltRule';
};
const matchedPrebuiltRuleConditional = state => {
  var _state$elastic_rule;
  if ((_state$elastic_rule = state.elastic_rule) !== null && _state$elastic_rule !== void 0 && _state$elastic_rule.prebuilt_rule_id) {
    return _langgraph.END;
  }
  return 'translationSubGraph';
};
function toolRouter(state) {
  var _lastMessage$tool_cal;
  const messages = state.messages;
  const lastMessage = messages.at(-1);
  return lastMessage !== null && lastMessage !== void 0 && (_lastMessage$tool_cal = lastMessage.tool_calls) !== null && _lastMessage$tool_cal !== void 0 && _lastMessage$tool_cal.length ? 'hasToolCalls' : 'noToolCalls';
}