"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationsDataService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _siem_migrations_base_service = require("../../common/siem_migrations_base_service");
var _field_maps = require("./field_maps");
var _dashboard_migrations_data_client = require("./dashboard_migrations_data_client");
var _field_maps2 = require("../../common/data/field_maps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DashboardMigrationsDataService extends _siem_migrations_base_service.SiemMigrationsBaseDataService {
  constructor(logger, kibanaVersion) {
    super(kibanaVersion);
    (0, _defineProperty2.default)(this, "baseIndexName", '.kibana-siem-dashboard-migrations');
    (0, _defineProperty2.default)(this, "adapters", void 0);
    this.logger = logger;
    this.kibanaVersion = kibanaVersion;
    this.adapters = {
      migrations: this.createDashboardIndexPatternAdapter({
        adapterId: 'migrations',
        fieldMap: _field_maps.dashboardMigrationsFieldMap
      }),
      dashboards: this.createDashboardIndexPatternAdapter({
        adapterId: 'dashboards',
        fieldMap: _field_maps.dashboardMigrationsDashboardsFieldMap
      }),
      resources: this.createDashboardIndexPatternAdapter({
        adapterId: 'resources',
        fieldMap: _field_maps2.migrationResourcesFieldMap
      })
    };
  }
  createDashboardIndexPatternAdapter({
    adapterId,
    fieldMap
  }) {
    const name = this.getAdapterIndexName(adapterId);
    this.logger.warn(JSON.stringify({
      message: 'Creating dashboard index pattern adapter',
      name,
      fieldMap
    }));
    return this.createIndexPatternAdapter({
      name,
      fieldMap
    });
  }
  async install(params) {
    await Promise.all([this.adapters.dashboards.install({
      ...params,
      logger: this.logger
    }), this.adapters.migrations.install({
      ...params,
      logger: this.logger
    }), this.adapters.resources.install({
      ...params,
      logger: this.logger
    })]);
  }
  async setup(params) {
    await this.install(params);
  }
  createClient({
    spaceId,
    currentUser,
    esScopedClient,
    dependencies
  }) {
    const indexNameProviders = {
      dashboards: this.createIndexNameProvider(this.adapters.dashboards, spaceId),
      migrations: this.createIndexNameProvider(this.adapters.migrations, spaceId),
      resources: this.createIndexNameProvider(this.adapters.resources, spaceId)
    };
    return new _dashboard_migrations_data_client.DashboardMigrationsDataClient(indexNameProviders, currentUser, esScopedClient, this.logger, spaceId, dependencies);
  }
}
exports.DashboardMigrationsDataService = DashboardMigrationsDataService;