"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNLToESQLQuery = void 0;
var _comments = require("../../../util/comments");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNLToESQLQuery = ({
  esqlKnowledgeBase,
  logger
}) => {
  return async input => {
    var _response$match$1$tri, _response$match, _response$match$, _response$match2;
    const mainPrompt = await _prompts.NL_TO_ESQL_TRANSLATION_PROMPT.format({
      nl_query: input.query
    });
    const indexPatternPrompt = await _prompts.NL_TO_ESQL_INDEX_PATTERN_PROMPT.format({
      index_pattern: input.indexPattern
    });
    const response = await esqlKnowledgeBase.translate(input.indexPattern ? `${indexPatternPrompt}\n${mainPrompt}` : mainPrompt);
    const esqlQuery = (_response$match$1$tri = (_response$match = response.match(/```esql\n([\s\S]*?)\n```/)) === null || _response$match === void 0 ? void 0 : _response$match[1].trim()) !== null && _response$match$1$tri !== void 0 ? _response$match$1$tri : '';
    if (!esqlQuery) {
      logger.warn('Failed to extract ESQL query from translation response');
      const comment = '## Translation Summary\n\nFailed to extract ESQL query from translation response';
      return {
        comments: [(0, _comments.generateAssistantComment)(comment)]
      };
    }
    const translationSummary = (_response$match$ = (_response$match2 = response.match(/## Translation Summary[\s\S]*$/)) === null || _response$match2 === void 0 ? void 0 : _response$match2[0]) !== null && _response$match$ !== void 0 ? _response$match$ : '';
    return {
      esqlQuery,
      comments: [(0, _comments.generateAssistantComment)((0, _comments.cleanMarkdown)(translationSummary))]
    };
  };
};
exports.getNLToESQLQuery = getNLToESQLQuery;