"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFixEsqlQueryErrors = void 0;
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFixEsqlQueryErrors = ({
  esqlKnowledgeBase,
  logger
}) => {
  return async input => {
    var _response$match;
    if (!input.validationErrors) {
      logger.debug('Trying to fix errors without validationErrors');
      return {};
    }
    if (!input.invalidQuery) {
      logger.debug('Trying to fix errors without invalidQuery');
      return {};
    }
    const prompt = await _prompts.RESOLVE_ESQL_ERRORS_TEMPLATE.format({
      esql_errors: input.validationErrors,
      esql_query: input.invalidQuery
    });
    const response = await esqlKnowledgeBase.translate(prompt);
    const query = (_response$match = response.match(/```esql\n([\s\S]*?)\n```/)) === null || _response$match === void 0 ? void 0 : _response$match[1];
    return {
      query
    };
  };
};
exports.getFixEsqlQueryErrors = getFixEsqlQueryErrors;