"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEntityAnalyticsRoutes = void 0;
var _routes = require("./asset_criticality/routes");
var _routes2 = require("./risk_score/routes");
var _routes3 = require("./risk_engine/routes");
var _routes4 = require("./entity_store/routes");
var _register_privilege_monitoring_routes = require("./privilege_monitoring/routes/register_privilege_monitoring_routes");
var _routes5 = require("./migrations/routes");
var _routes6 = require("./entity_details/routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerEntityAnalyticsRoutes = routeDeps => {
  (0, _routes.registerAssetCriticalityRoutes)(routeDeps);
  (0, _routes2.registerRiskScoreRoutes)(routeDeps);
  (0, _routes3.registerRiskEngineRoutes)(routeDeps);
  (0, _routes5.registerMigrationsRoutes)(routeDeps);
  if (!routeDeps.config.experimentalFeatures.entityStoreDisabled) {
    (0, _routes4.registerEntityStoreRoutes)(routeDeps);
  }
  (0, _register_privilege_monitoring_routes.registerPrivilegeMonitoringRoutes)(routeDeps);
  if (routeDeps.config.experimentalFeatures.entityDetailsHighlightsEnabled) {
    (0, _routes6.registerEntityDetailsRoutes)(routeDeps);
  }
};
exports.registerEntityAnalyticsRoutes = registerEntityAnalyticsRoutes;