"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldDescriptors = void 0;
var _server = require("@kbn/data-views-plugin/server");
var _langgraph = require("@langchain/langgraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldDescriptors = ({
  esClient
}) => {
  const indexPatternsFetcher = new _server.IndexPatternsFetcher(esClient);
  return async state => {
    if (state.input === undefined) {
      throw new Error('State input is undefined');
    }
    const {
      indexPattern
    } = state.input;
    try {
      const {
        fields: fieldDescriptors
      } = await indexPatternsFetcher.getFieldsForWildcard({
        pattern: indexPattern,
        fieldCapsOptions: {
          allow_no_indices: false,
          includeUnmapped: false
        }
      });
      return new _langgraph.Command({
        update: {
          fieldDescriptors
        }
      });
    } catch (error) {
      return new _langgraph.Command({
        update: {
          fieldDescriptors: []
        }
      });
    }
  };
};
exports.getFieldDescriptors = getFieldDescriptors;