"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tokens = exports.SuricataSignature = exports.SignatureId = exports.SURICATA_SIGNATURE_ID_FIELD_NAME = exports.SURICATA_SIGNATURE_FIELD_NAME = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _links = require("../../../../../../common/components/links");
var _cell_actions_renderer = require("../../../../../../common/components/cell_actions/cell_actions_renderer");
var _helpers = require("../helpers");
var _suricata_links = require("./suricata_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/suricata/suricata_signature.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SURICATA_SIGNATURE_FIELD_NAME = exports.SURICATA_SIGNATURE_FIELD_NAME = 'suricata.eve.alert.signature';
const SURICATA_SIGNATURE_ID_FIELD_NAME = exports.SURICATA_SIGNATURE_ID_FIELD_NAME = 'suricata.eve.alert.signature_id';
const SignatureFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 77px;
`;
SignatureFlexItem.displayName = 'SignatureFlexItem';
const Badge = (0, _styledComponents.default)(_eui.EuiBadge)`
  vertical-align: top;
`;
Badge.displayName = 'Badge';
const LinkFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: 6px;
`;
LinkFlexItem.displayName = 'LinkFlexItem';
const Tokens = exports.Tokens = /*#__PURE__*/_react.default.memo(({
  tokens
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tokens.map(token => /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  key: token,
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "tag",
  color: "hollow",
  title: "",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 9
  }
}, token)))));
Tokens.displayName = 'Tokens';
const SignatureId = exports.SignatureId = /*#__PURE__*/_react.default.memo(({
  scopeId,
  signatureId
}) => {
  return /*#__PURE__*/_react.default.createElement(SignatureFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
    field: SURICATA_SIGNATURE_ID_FIELD_NAME,
    value: signatureId,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Badge, {
    iconType: "number",
    color: "hollow",
    title: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, signatureId)));
});
SignatureId.displayName = 'SignatureId';
const SuricataSignature = exports.SuricataSignature = /*#__PURE__*/_react.default.memo(({
  scopeId,
  id,
  signature,
  signatureId
}) => {
  const tokens = (0, _suricata_links.getBeginningTokens)(signature);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(SignatureId, {
    scopeId: scopeId,
    signatureId: signatureId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(Tokens, {
    tokens: tokens,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(LinkFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
    "data-test-subj": "signature-link",
    field: SURICATA_SIGNATURE_FIELD_NAME,
    value: signature,
    tooltipPosition: "bottom",
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_links.GoogleLink, {
    link: signature,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, signature.split(' ').splice(tokens.length).join(' '))))));
});
SuricataSignature.displayName = 'SuricataSignature';