"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotePreviewsContainer = exports.NotePreviews = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _constants = require("../../../../data_view_manager/constants");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _kibana = require("../../../../common/lib/kibana");
var _panel_keys = require("../../../../flyout/document_details/shared/constants/panel_keys");
var _empty_value = require("../../../../common/components/empty_value");
var _markdown_editor = require("../../../../common/components/markdown_editor");
var _store = require("../../../store");
var _helpers = require("../../timeline/body/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _timeline = require("../../../../../common/types/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_delete_note = require("./hooks/use_delete_note");
var _selectors = require("../../timeline/tabs/notes/selectors");
var _telemetry = require("../../../../common/lib/telemetry");
var _user_privileges = require("../../../../common/components/user_privileges");
var _containers = require("../../../../sourcerer/containers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/open_timeline/note_previews/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NotePreviewsContainer = exports.NotePreviewsContainer = _styledComponents.default.section`
  padding-top: ${({
  theme
}) => `${theme.eui.euiSizeS}`};
`;
NotePreviewsContainer.displayName = 'NotePreviewsContainer';
const ToggleEventDetailsButtonComponent = ({
  eventId,
  timelineId
}) => {
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.PageScope.timeline);
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_constants.PageScope.timeline);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const handleClick = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: eventId,
          indexName: selectedPatterns.join(','),
          scopeId: timelineId
        }
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: timelineId,
      panel: 'right'
    });
  }, [eventId, openFlyout, selectedPatterns, telemetry, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "notes-toggle-event-details",
    title: i18n.TOGGLE_EXPAND_EVENT_DETAILS,
    "aria-label": i18n.TOGGLE_EXPAND_EVENT_DETAILS,
    color: "text",
    iconType: "arrowRight",
    onClick: handleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  });
};
const ToggleEventDetailsButton = /*#__PURE__*/_react.default.memo(ToggleEventDetailsButtonComponent);
const DeleteNoteConfirm = /*#__PURE__*/_react.default.memo(({
  closeModal,
  confirmModal
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: i18n.DELETE_NOTE_CONFIRM,
    titleProps: {
      id: modalTitleId
    },
    onCancel: closeModal,
    onConfirm: confirmModal,
    cancelButtonText: i18n.CANCEL_DELETE_NOTE,
    confirmButtonText: i18n.DELETE_NOTE,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  });
});
DeleteNoteConfirm.displayName = 'DeleteNoteConfirm';
const DeleteNoteButton = /*#__PURE__*/_react.default.memo(({
  noteId,
  eventId,
  confirmingNoteId,
  timelineId,
  eventIdToNoteIds,
  savedObjectId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [showModal, setShowModal] = (0, _react.useState)(false);
  const {
    mutate,
    isLoading
  } = (0, _use_delete_note.useDeleteNote)(noteId, eventId, eventIdToNoteIds, savedObjectId);
  const handleOpenDeleteModal = (0, _react.useCallback)(() => {
    setShowModal(true);
    dispatch(_store.timelineActions.setConfirmingNoteId({
      confirmingNoteId: noteId,
      id: timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active
    }));
  }, [noteId, dispatch, timelineId]);
  const handleCancelDelete = (0, _react.useCallback)(() => {
    setShowModal(false);
    dispatch(_store.timelineActions.setConfirmingNoteId({
      confirmingNoteId: null,
      id: timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active
    }));
  }, [dispatch, timelineId]);
  const handleConfirmDelete = (0, _react.useCallback)(() => {
    mutate(savedObjectId);
    setShowModal(false);
    dispatch(_store.timelineActions.setConfirmingNoteId({
      confirmingNoteId: null,
      id: timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active
    }));
  }, [mutate, savedObjectId, dispatch, timelineId]);
  const disableDelete = (0, _react.useMemo)(() => {
    return isLoading || savedObjectId == null;
  }, [isLoading, savedObjectId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    title: i18n.DELETE_NOTE,
    "aria-label": i18n.DELETE_NOTE,
    "data-test-subj": 'delete-note',
    color: "text",
    iconType: "trash",
    onClick: handleOpenDeleteModal,
    disabled: disableDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }), confirmingNoteId === noteId && showModal ? /*#__PURE__*/_react.default.createElement(DeleteNoteConfirm, {
    closeModal: handleCancelDelete,
    confirmModal: handleConfirmDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }) : null);
});
DeleteNoteButton.displayName = 'DeleteNoteButton';
const NoteActions = /*#__PURE__*/_react.default.memo(({
  eventId,
  timelineId,
  noteId,
  confirmingNoteId,
  eventIdToNoteIds,
  savedObjectId,
  showToggleEventDetailsAction = true
}) => {
  const {
    notesPrivileges: {
      crud: canCrudNotes
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const DeleteButton = canCrudNotes ? /*#__PURE__*/_react.default.createElement(DeleteNoteButton, {
    noteId: noteId,
    eventId: eventId,
    confirmingNoteId: confirmingNoteId,
    savedObjectId: savedObjectId,
    timelineId: timelineId,
    eventIdToNoteIds: eventIdToNoteIds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }) : null;
  return eventId && timelineId ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showToggleEventDetailsAction ? /*#__PURE__*/_react.default.createElement(ToggleEventDetailsButton, {
    eventId: eventId,
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }) : null, DeleteButton) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, DeleteButton);
});
NoteActions.displayName = 'NoteActions';
/**
 * Renders a preview of a note in the All / Open Timelines table
 */

const NotePreviews = exports.NotePreviews = /*#__PURE__*/_react.default.memo(({
  notes,
  timelineId,
  showTimelineDescription,
  showToggleEventDetailsAction = true
}) => {
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const getTimelineNotes = (0, _react.useMemo)(() => (0, _selectors.getTimelineNoteSelector)(), []);
  const timeline = (0, _use_selector.useDeepEqualSelector)(state => getTimeline(state, timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active));
  const timelineNotes = (0, _use_selector.useDeepEqualSelector)(state => getTimelineNotes(state, timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active));
  const eventIdToNoteIds = timelineNotes === null || timelineNotes === void 0 ? void 0 : timelineNotes.eventIdToNoteIds;
  const descriptionList = (0, _react.useMemo)(() => showTimelineDescription && timelineId && timeline !== null && timeline !== void 0 && timeline.description ? [{
    username: (0, _empty_value.defaultToEmptyTag)(timeline.updatedBy),
    event: i18n.ADDED_A_DESCRIPTION,
    'data-test-subj': 'note-preview-description',
    id: 'note-preview-description',
    timestamp: timeline.updated ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      "data-test-subj": "updated",
      value: new Date(timeline.updated),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 19
      }
    }) : (0, _empty_value.getEmptyValue)(),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 27
      }
    }, timeline.description),
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      "data-test-subj": "avatar",
      name: timeline.updatedBy != null ? timeline.updatedBy : '?',
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 19
      }
    }),
    actions: null
  }] : [], [timeline, timelineId, showTimelineDescription]);
  const notesList = (0, _react.useMemo)(() => (0, _fp.uniqBy)('savedObjectId', notes).map(note => {
    var _note$eventId, _note$updatedBy, _note$note;
    const eventId = eventIdToNoteIds != null ? Object.entries(eventIdToNoteIds).reduce((acc, [id, noteIds]) => {
      var _note$noteId;
      return noteIds.includes((_note$noteId = note.noteId) !== null && _note$noteId !== void 0 ? _note$noteId : '') ? id : acc;
    }, null) : (_note$eventId = note.eventId) !== null && _note$eventId !== void 0 ? _note$eventId : null;
    return {
      'data-test-subj': `note-preview-${note.savedObjectId}`,
      username: (0, _empty_value.defaultToEmptyTag)(note.updatedBy),
      event: i18n.ADDED_A_NOTE,
      timestamp: note.updated ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        "data-test-subj": "updated",
        value: new Date(note.updated),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 302,
          columnNumber: 15
        }
      }) : (0, _empty_value.getEmptyValue)(),
      children: /*#__PURE__*/_react.default.createElement("div", {
        className: _helpers.NOTE_CONTENT_CLASS_NAME,
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
        "data-test-subj": "screenReaderOnlyUserAddedANote",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 308,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 309,
          columnNumber: 19
        }
      }, `${(_note$updatedBy = note.updatedBy) !== null && _note$updatedBy !== void 0 ? _note$updatedBy : i18n.AN_UNKNOWN_USER} ${i18n.ADDED_A_NOTE}`)), /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 311,
          columnNumber: 17
        }
      }, (_note$note = note.note) !== null && _note$note !== void 0 ? _note$note : '')),
      actions: /*#__PURE__*/_react.default.createElement(NoteActions, {
        eventId: eventId,
        timelineId: timelineId,
        noteId: note.noteId,
        savedObjectId: note.savedObjectId,
        confirmingNoteId: timeline === null || timeline === void 0 ? void 0 : timeline.confirmingNoteId,
        eventIdToNoteIds: eventIdToNoteIds,
        showToggleEventDetailsAction: showToggleEventDetailsAction,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 315,
          columnNumber: 15
        }
      }),
      timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        "data-test-subj": "avatar",
        name: note.updatedBy != null ? note.updatedBy : '?',
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 326,
          columnNumber: 15
        }
      })
    };
  }), [eventIdToNoteIds, notes, timelineId, timeline === null || timeline === void 0 ? void 0 : timeline.confirmingNoteId, showToggleEventDetailsAction]);
  const commentList = (0, _react.useMemo)(() => [...descriptionList, ...notesList], [descriptionList, notesList]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    "data-test-subj": "note-comment-list",
    comments: commentList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 12
    }
  });
});
NotePreviews.displayName = 'NotePreviews';