"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateInTimelineContextMenu = exports.InvestigateInTimelineButtonIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../common/lib/kibana");
var _translations = require("./translations");
var _use_investigate_in_timeline = require("../../../hooks/use_investigate_in_timeline");
var _timeline_capabilities = require("../../../../common/utils/timeline_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/timeline/components/investigate_in_timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Investigate in timeline button, uses the InvestigateInTimelineAction component (x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/timeline_actions/investigate_in_timeline_action.tsx)
 * retrieved from the SecuritySolutionContext.
 *
 * This component renders an {@link EuiContextMenu}.
 *
 * @returns investigate in timeline for a context menu
 */
const InvestigateInTimelineContextMenu = ({
  data,
  onClick,
  'data-test-subj': dataTestSub
}) => {
  const {
    investigateInTimelineFn
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)({
    indicator: data
  });
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  const menuItemClicked = (0, _react.useCallback)(() => {
    if (onClick) onClick();
    investigateInTimelineFn();
  }, [investigateInTimelineFn, onClick]);
  if (!hasAccessToTimeline || !investigateInTimelineFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    onClick: menuItemClicked,
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Investigate in Timeline",
    id: "xpack.securitySolution.threatIntelligence.investigateInTimelineButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }));
};

/**
 * Investigate in timeline button uses the InvestigateInTimelineAction component (x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/timeline_actions/investigate_in_timeline_action.tsx)
 * retrieved from the SecuritySolutionContext.
 *
 * This component renders an {@link EuiButtonIcon}.
 *
 * @returns add to timeline button icon
 */
exports.InvestigateInTimelineContextMenu = InvestigateInTimelineContextMenu;
const InvestigateInTimelineButtonIcon = ({
  data,
  'data-test-subj': dataTestSub
}) => {
  const {
    investigateInTimelineFn
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)({
    indicator: data
  });
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  if (!hasAccessToTimeline || !investigateInTimelineFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.BUTTON_ICON_LABEL,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.BUTTON_ICON_LABEL,
    color: "text",
    "data-test-subj": dataTestSub,
    iconType: "timeline",
    onClick: investigateInTimelineFn,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }));
};
exports.InvestigateInTimelineButtonIcon = InvestigateInTimelineButtonIcon;