"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/data-views-plugin/common");
var _constants = require("../../../../common/store/inputs/constants");
var _search_bar = require("../../../../common/components/search_bar");
var _filters_global = require("../../../../common/components/filters_global");
var _wrapper = require("../components/barchart/wrapper");
var _table = require("../components/table/table");
var _use_aggregated_indicators = require("../hooks/use_aggregated_indicators");
var _use_indicators = require("../hooks/use_indicators");
var _use_ti_data_view = require("../hooks/use_ti_data_view");
var _layout = require("../../../components/layout");
var _use_filters = require("../../query_bar/hooks/use_filters");
var _field_types_provider = require("../../../containers/field_types_provider");
var _inspector = require("../../../containers/inspector");
var _use_column_settings = require("../hooks/use_column_settings");
var _filters = require("../containers/filters");
var _update_status = require("../../../components/update_status");
var _screen_reader_a11y = require("../containers/screen_reader_a11y");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/pages/indicators.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndicatorsPageProviders = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_screen_reader_a11y.ScreenReaderAnnouncementsProvider, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_filters.IndicatorsFilters, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_field_types_provider.FieldTypesProvider, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_inspector.InspectorProvider, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 9
  }
}, children))));
const IndicatorsPageContent = () => {
  const {
    sourcererDataView: sourcererDataViewSpec,
    browserFields
  } = (0, _use_ti_data_view.useTIDataView)();
  const {
    fieldFormats
  } = (0, _kibana.useKibana)().services;
  const dataView = new _common.DataView({
    spec: sourcererDataViewSpec,
    fieldFormats
  });
  const columnSettings = (0, _use_column_settings.useColumnSettings)();
  const {
    timeRange,
    filters,
    filterQuery
  } = (0, _use_filters.useFilters)();
  const {
    indicatorCount,
    indicators,
    onChangeItemsPerPage,
    onChangePage,
    pagination,
    isLoading: isLoadingIndicators,
    isFetching: isFetchingIndicators,
    dataUpdatedAt
  } = (0, _use_indicators.useIndicators)({
    filters,
    filterQuery,
    timeRange,
    sorting: columnSettings.sorting.columns
  });
  const {
    dateRange,
    series,
    selectedField,
    onFieldChange,
    isLoading: isLoadingAggregatedIndicators,
    isFetching: isFetchingAggregatedIndicators
  } = (0, _use_aggregated_indicators.useAggregatedIndicators)({
    timeRange,
    filters,
    filterQuery
  });
  return /*#__PURE__*/_react.default.createElement(_layout.DefaultPageLayout, {
    pageTitle: "Indicators",
    subHeader: /*#__PURE__*/_react.default.createElement(_update_status.UpdateStatus, {
      isUpdating: isFetchingIndicators,
      updatedAt: dataUpdatedAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 18
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    dataView: dataView,
    id: _constants.InputsModelId.global,
    sourcererDataViewSpec: sourcererDataViewSpec // TODO remove when we remove the newDataViewPickerEnabled feature flag
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_wrapper.IndicatorsBarChartWrapper, {
    dateRange: dateRange,
    series: series,
    timeRange: timeRange,
    field: selectedField,
    onFieldChange: onFieldChange,
    isFetching: isFetchingAggregatedIndicators,
    isLoading: isLoadingAggregatedIndicators,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_table.IndicatorsTable, {
    browserFields: browserFields,
    columnSettings: columnSettings,
    pagination: pagination,
    indicatorCount: indicatorCount,
    indicators: indicators,
    isLoading: isLoadingIndicators,
    isFetching: isFetchingIndicators,
    onChangeItemsPerPage: onChangeItemsPerPage,
    onChangePage: onChangePage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }));
};
const IndicatorsPage = () => /*#__PURE__*/_react.default.createElement(IndicatorsPageProviders, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 117,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(IndicatorsPageContent, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 118,
    columnNumber: 5
  }
}));
exports.IndicatorsPage = IndicatorsPage;