"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitSourcerer = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _constants = require("../../data_view_manager/constants");
var _store = require("../store");
var _user_info = require("../../detections/components/user_info");
var _store2 = require("../../timelines/store");
var _types = require("../../../common/types");
var _use_selector = require("../../common/hooks/use_selector");
var _helpers = require("../store/helpers");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _create_sourcerer_data_view = require("./create_sourcerer_data_view");
var _use_data_view = require("../../common/containers/source/use_data_view");
var _kibana = require("../../common/lib/kibana");
var _ = require(".");
var _use_sync_url_state = require("../../data_view_manager/hooks/use_sync_url_state");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultInitResult = {
  browserFields: {}
};
const useInitSourcerer = (scopeId = _constants.PageScope.default) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');

  /* eslint-disable react-hooks/rules-of-hooks */
  // NOTE: skipping the entire hook on purpose when the new picker is enabled
  // will be removed as part of the cleanup in https://github.com/elastic/security-team/issues/11959
  if (newDataViewPickerEnabled) {
    return defaultInitResult;
  }
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data: {
      dataViews
    }
  } = (0, _kibana.useKibana)().services;
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const initialTimelineSourcerer = (0, _react.useRef)(true);
  const initialDetectionSourcerer = (0, _react.useRef)(true);
  const {
    loading: loadingSignalIndex,
    isSignalIndexExists,
    signalIndexName
  } = (0, _user_info.useUserInfo)();
  (0, _use_sync_url_state.useSyncSourcererUrlState)(scopeId);
  const signalIndexNameSourcerer = (0, _reactRedux.useSelector)(_store.sourcererSelectors.signalIndexName);
  const defaultDataView = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView);
  const {
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  (0, _react.useEffect)(() => {
    if (defaultDataView.error != null) {
      addWarning({
        title: _i18n.i18n.translate('xpack.securitySolution.sourcerer.permissions.title', {
          defaultMessage: 'Write role required to generate data'
        }),
        text: _i18n.i18n.translate('xpack.securitySolution.sourcerer.permissions.toastMessage', {
          defaultMessage: 'Users with write permission need to access the Elastic Security app to initialize the app source data.'
        })
      });
    }
  }, [addWarning, defaultDataView.error]);
  const getTimelineSelector = (0, _react.useMemo)(() => _store2.timelineSelectors.getTimelineByIdSelector(), []);
  const activeTimeline = (0, _use_selector.useDeepEqualSelector)(state => getTimelineSelector(state, _types.TimelineId.active));
  const scopeDataViewId = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeSelectedDataViewId(state, scopeId);
  });
  const selectedPatterns = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeSelectedPatterns(state, scopeId);
  });
  const missingPatterns = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeMissingPatterns(state, scopeId);
  });
  const kibanaDataViews = (0, _reactRedux.useSelector)(_store.sourcererSelectors.kibanaDataViews);
  const timelineDataViewId = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeSelectedDataViewId(state, _constants.PageScope.timeline);
  });
  const timelineSelectedPatterns = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeSelectedPatterns(state, _constants.PageScope.timeline);
  });
  const timelineMissingPatterns = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeMissingPatterns(state, _constants.PageScope.timeline);
  });
  const timelineSelectedDataView = (0, _react.useMemo)(() => {
    return kibanaDataViews.find(dataView => dataView.id === timelineDataViewId);
  }, [kibanaDataViews, timelineDataViewId]);
  const {
    indexFieldsSearch
  } = (0, _use_data_view.useDataView)();

  /*
   * Note for future engineer:
   * we changed the logic to not fetch all the index fields for every data view on the loading of the app
   * because user can have a lot of them and it can slow down the loading of the app
   * and maybe blow up the memory of the browser. We decided to load this data view on demand,
   * we know that will only have to load this dataview on default and timeline scope.
   * We will use two conditions to see if we need to fetch and initialize the dataview selected.
   * First, we will make sure that we did not already fetch them by using `searchedIds`
   * and then we will init them if selectedPatterns and missingPatterns are empty.
   */
  const searchedIds = (0, _react.useRef)([]);
  (0, _react.useEffect)(() => {
    const activeDataViewIds = [...new Set([scopeDataViewId, timelineDataViewId])];
    activeDataViewIds.forEach((id, i) => {
      if (id != null && id.length > 0 && !searchedIds.current.includes(id)) {
        searchedIds.current = [...searchedIds.current, id];
        const currentScope = i === 0 ? _constants.PageScope.default : _constants.PageScope.timeline;
        const needToBeInit = id === scopeDataViewId ? selectedPatterns.length === 0 && missingPatterns.length === 0 : timelineDataViewId === id ? timelineMissingPatterns.length === 0 && (timelineSelectedDataView === null || timelineSelectedDataView === void 0 ? void 0 : timelineSelectedDataView.patternList.length) === 0 : false;
        indexFieldsSearch({
          dataViewId: id,
          scopeId: currentScope,
          needToBeInit,
          ...(needToBeInit && currentScope === _constants.PageScope.timeline ? {
            skipScopeUpdate: timelineSelectedPatterns.length > 0
          } : {})
        });
      }
    });
  }, [indexFieldsSearch, missingPatterns.length, scopeDataViewId, selectedPatterns.length, timelineDataViewId, timelineMissingPatterns.length, timelineSelectedDataView, timelineSelectedPatterns.length]);

  // Related to timeline
  (0, _react.useEffect)(() => {
    if (!loadingSignalIndex && signalIndexName != null && signalIndexNameSourcerer == null && (activeTimeline === null || activeTimeline === void 0 ? void 0 : activeTimeline.savedObjectId) == null && initialTimelineSourcerer.current && defaultDataView.id.length > 0) {
      initialTimelineSourcerer.current = false;
      dispatch(_store.sourcererActions.setSelectedDataView({
        id: _constants.PageScope.timeline,
        selectedDataViewId: defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(defaultDataView, _constants.PageScope.timeline, signalIndexName, true)
      }));
      dispatch(_store.sourcererActions.setSelectedDataView({
        id: _constants.PageScope.analyzer,
        selectedDataViewId: defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(defaultDataView, _constants.PageScope.analyzer, signalIndexName, true)
      }));
    } else if (signalIndexNameSourcerer != null && (activeTimeline === null || activeTimeline === void 0 ? void 0 : activeTimeline.savedObjectId) == null && initialTimelineSourcerer.current && defaultDataView.id.length > 0) {
      initialTimelineSourcerer.current = false;
      dispatch(_store.sourcererActions.setSelectedDataView({
        id: _constants.PageScope.timeline,
        selectedDataViewId: defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(defaultDataView, _constants.PageScope.timeline, signalIndexNameSourcerer, true)
      }));
      dispatch(_store.sourcererActions.setSelectedDataView({
        id: _constants.PageScope.analyzer,
        selectedDataViewId: defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(defaultDataView, _constants.PageScope.analyzer, signalIndexNameSourcerer, true)
      }));
    }
  }, [activeTimeline === null || activeTimeline === void 0 ? void 0 : activeTimeline.savedObjectId, defaultDataView, dispatch, loadingSignalIndex, signalIndexName, signalIndexNameSourcerer]);
  const {
    dataViewId,
    browserFields
  } = (0, _.useSourcererDataView)(scopeId);
  const updateSourcererDataView = (0, _react.useCallback)(newSignalsIndex => {
    const asyncSearch = async newPatternList => {
      abortCtrl.current = new AbortController();
      dispatch(_store.sourcererActions.setSourcererScopeLoading({
        loading: true
      }));
      try {
        const response = await (0, _create_sourcerer_data_view.createSourcererDataView)({
          dataViewService: dataViews,
          defaultDetails: {
            dataViewId,
            patternList: newPatternList
          },
          alertDetails: {}
        });
        if (response !== null && response !== void 0 && response.defaultDataView.patternList.includes(newSignalsIndex)) {
          // first time signals is defined and validated in the sourcerer
          // redo indexFieldsSearch
          indexFieldsSearch({
            dataViewId: response.defaultDataView.id
          });
          dispatch(_store.sourcererActions.setSourcererDataViews(response));
        }
        dispatch(_store.sourcererActions.setSourcererScopeLoading({
          loading: false
        }));
      } catch (err) {
        if (err.name === 'AbortError') {
          // the fetch was canceled, we don't need to do anything about it
        } else {
          addError(err, {
            title: _i18n.i18n.translate('xpack.securitySolution.sourcerer.error.title', {
              defaultMessage: 'Error updating Security Data View'
            }),
            toastMessage: _i18n.i18n.translate('xpack.securitySolution.sourcerer.error.toastMessage', {
              defaultMessage: 'Refresh the page'
            })
          });
        }
        dispatch(_store.sourcererActions.setSourcererScopeLoading({
          loading: false
        }));
      }
    };
    if (defaultDataView.title.indexOf(newSignalsIndex) === -1) {
      abortCtrl.current.abort();
      asyncSearch([...defaultDataView.title.split(','), newSignalsIndex]);
    }
  }, [defaultDataView.title, dispatch, dataViews, dataViewId, indexFieldsSearch, addError]);
  const onSignalIndexUpdated = (0, _react.useCallback)(() => {
    if (!loadingSignalIndex && signalIndexName != null && signalIndexNameSourcerer == null && defaultDataView.id.length > 0) {
      updateSourcererDataView(signalIndexName);
      dispatch(_store.sourcererActions.setSignalIndexName({
        signalIndexName
      }));
    }
  }, [defaultDataView.id.length, dispatch, loadingSignalIndex, signalIndexName, signalIndexNameSourcerer, updateSourcererDataView]);
  (0, _react.useEffect)(() => {
    onSignalIndexUpdated();
    // because we only want onSignalIndexUpdated to run when signalIndexName updates,
    // but we want to know about the updates from the dependencies of onSignalIndexUpdated
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [signalIndexName]);

  // Related to the detection page
  (0, _react.useEffect)(() => {
    if (scopeId === _constants.PageScope.alerts && isSignalIndexExists && signalIndexName != null && initialDetectionSourcerer.current && defaultDataView.id.length > 0) {
      initialDetectionSourcerer.current = false;
      dispatch(_store.sourcererActions.setSelectedDataView({
        id: _constants.PageScope.alerts,
        selectedDataViewId: defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(defaultDataView, _constants.PageScope.alerts, signalIndexName, true)
      }));
    } else if (scopeId === _constants.PageScope.alerts && signalIndexNameSourcerer != null && initialTimelineSourcerer.current && defaultDataView.id.length > 0) {
      initialDetectionSourcerer.current = false;
      _store.sourcererActions.setSelectedDataView({
        id: _constants.PageScope.alerts,
        selectedDataViewId: defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(defaultDataView, _constants.PageScope.alerts, signalIndexNameSourcerer, true)
      });
    }
  }, [defaultDataView, dispatch, isSignalIndexExists, scopeId, signalIndexName, signalIndexNameSourcerer]);
  return (0, _react.useMemo)(() => ({
    browserFields
  }), [browserFields]);
};
exports.useInitSourcerer = useInitSourcerer;