"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSLATION_QUERY_TOOLTIP = exports.TRANSLATION_QUERY_PLACEHOLDER = exports.SPLUNK_QUERY_TOOLTIP = exports.SPLUNK_QUERY_TITLE = exports.SAVE = exports.QRADAR_RULE_TITLE_TOOLTIP = exports.QRADAR_RULE_TITLE = exports.PREBUILT_RULE_TITLE = exports.MACHINE_LEARNING_RULE_TOOLTIP = exports.MACHINE_LEARNING_RULE_TITLE = exports.MACHINE_LEARNING_RULE_QUERY_PLACEHOLDER = exports.EDIT = exports.CUSTOM_TRANSLATION_TITLE = exports.CANCEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPLUNK_QUERY_TITLE = exports.SPLUNK_QUERY_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.splunkQuery.title', {
  defaultMessage: 'Splunk query'
});
const SPLUNK_QUERY_TOOLTIP = exports.SPLUNK_QUERY_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.splunkQuery.tooltip', {
  defaultMessage: 'This is the rule name detected in the export file uploaded for translation'
});
const QRADAR_RULE_TITLE = exports.QRADAR_RULE_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.qradarRule.title', {
  defaultMessage: 'QRadar rule definition'
});
const QRADAR_RULE_TITLE_TOOLTIP = exports.QRADAR_RULE_TITLE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.qradarRule.tooltip', {
  defaultMessage: 'This is the original QRadar rule definition in XML format as exported from QRadar'
});
const CUSTOM_TRANSLATION_TITLE = exports.CUSTOM_TRANSLATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.customTranslation.title', {
  defaultMessage: 'ES|QL translation'
});
const PREBUILT_RULE_TITLE = queryLanguage => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.prebuiltRule.title', {
  defaultMessage: 'Mapped to Elastic authored {queryLanguage} rule  ',
  values: {
    queryLanguage
  }
});
exports.PREBUILT_RULE_TITLE = PREBUILT_RULE_TITLE;
const TRANSLATION_QUERY_PLACEHOLDER = exports.TRANSLATION_QUERY_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.translationQuery.queryPlaceholder', {
  defaultMessage: 'This rule has not been translated. Click edit to start writing.'
});
const TRANSLATION_QUERY_TOOLTIP = exports.TRANSLATION_QUERY_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.machineLearningRule.tooltip', {
  defaultMessage: 'Elastic prebuilt rules use EQL, ES|QL, KQL or Lucene. AI-translated rules use ES|QL.'
});
const MACHINE_LEARNING_RULE_TITLE = exports.MACHINE_LEARNING_RULE_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.machineLearningRule.title', {
  defaultMessage: 'Mapped to Elastic authored machine learning rule'
});
const MACHINE_LEARNING_RULE_QUERY_PLACEHOLDER = exports.MACHINE_LEARNING_RULE_QUERY_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.machineLearningRule.queryPlaceholder', {
  defaultMessage: 'This query was mapped to a Machine Learning rule. See more details in the Overview tab above.'
});
const MACHINE_LEARNING_RULE_TOOLTIP = exports.MACHINE_LEARNING_RULE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.machineLearningRule.tooltip', {
  defaultMessage: 'Machine learning rules may require additional configuration.'
});
const EDIT = exports.EDIT = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.editButtonLabel', {
  defaultMessage: 'Edit'
});
const SAVE = exports.SAVE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.saveButtonLabel', {
  defaultMessage: 'Save'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});