"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCompleteBadgeStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *
 * Provides the styles for the "Translation complete" badge used when a migration is complete
 * */
const useCompleteBadgeStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return (0, _react.css)`
    background-color: ${isDarkMode ? euiTheme.colors.success : euiTheme.colors.backgroundBaseSuccess};
    color: ${isDarkMode ? euiTheme.colors.plainDark : euiTheme.colors.textSuccess};
    text-decoration: none;
  `;
};
exports.useCompleteBadgeStyles = useCompleteBadgeStyles;