"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Resolver = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _resolver_without_providers = require("./resolver_without_providers");
var _actions = require("../store/actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * The `Resolver` component to use. This sets up the DataAccessLayer provider. Use `ResolverWithoutProviders` in tests or in other scenarios where you want to provide a different (or fake) data access layer.
 */
// eslint-disable-next-line react/display-name
const Resolver = exports.Resolver = /*#__PURE__*/_react.default.memo(props => {
  const store = (0, _reactRedux.useSelector)(state => state.analyzer[props.resolverComponentInstanceID]);
  const dispatch = (0, _reactRedux.useDispatch)();
  if (!store) {
    dispatch((0, _actions.createResolver)({
      id: props.resolverComponentInstanceID
    }));
  }
  (0, _react.useEffect)(() => {
    if (props.shouldUpdate) {
      dispatch((0, _actions.createResolver)({
        id: props.resolverComponentInstanceID
      }));
    }
  }, [dispatch, props.shouldUpdate, props.resolverComponentInstanceID]);
  return /*#__PURE__*/_react.default.createElement(_resolver_without_providers.ResolverWithoutProviders, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 10
    }
  }));
});