"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EdgeLine = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _vector = require("../models/vector2");
var _font_size = require("./font_size");
var _use_colors = require("./use_colors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/edge_line.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StyledEdgeLine = _styledComponents.default.div`
  position: absolute;
  height: ${props => {
  return `${(0, _font_size.fontSize)(props.magFactorX, 12, 8.5)}px`;
}};
  background-color: ${props => props.resolverEdgeColor};
  z-index: 10;
`;
const StyledElapsedTime = _styledComponents.default.div`
  background-color: ${props => props.backgroundColor};
  color: ${props => props.textColor};
  font-size: ${props => `${props.scaledTypeSize}px`};
  font-weight: bold;
  max-width: 75%;
  overflow: hidden;
  position: absolute;
  text-overflow: ellipsis;
  top: 50%;
  white-space: nowrap;
  left: ${props => `${props.leftPct}%`};
  padding: 6px 8px;
  border-radius: 999px; // generate pill shape
  transform: translate(-50%, -50%);
  user-select: none;
`;

/**
 * A placeholder line segment view that connects process nodes.
 */
// eslint-disable-next-line react/display-name
const EdgeLine = exports.EdgeLine = /*#__PURE__*/_react.default.memo(({
  className,
  edgeLineMetadata,
  startPosition,
  endPosition,
  projectionMatrix
}) => {
  /**
   * Convert the start and end positions, which are in 'world' coordinates,
   * to `left` and `top` css values.
   */
  const screenStart = (0, _vector.applyMatrix3)(startPosition, projectionMatrix);
  const screenEnd = (0, _vector.applyMatrix3)(endPosition, projectionMatrix);
  const [xScale] = projectionMatrix;
  const colorMap = (0, _use_colors.useColors)();
  const elapsedTime = edgeLineMetadata === null || edgeLineMetadata === void 0 ? void 0 : edgeLineMetadata.elapsedTime;

  /**
   * We render the line using a short, long, `div` element. The length of this `div`
   * should be the same as the distance between the start and end points.
   */
  const length = (0, _vector.distance)(screenStart, screenEnd);
  const scaledTypeSize = (0, _font_size.fontSize)(xScale, 10, 7.5);
  const style = {
    left: `${screenStart[0]}px`,
    top: `${screenStart[1]}px`,
    width: `${length}px`,
    /**
     * Transform from the left of the div, as the left side of the `div` is positioned
     * at the start point of the line segment.
     */
    transformOrigin: 'top left',
    /**
     * Translate the `div` in the y axis to accomodate for the height of the `div`.
     * Also rotate the `div` in the z axis so that it's angle matches the angle
     * between the start and end points.
     */
    transform: `translateY(-50%) rotateZ(${(0, _vector.angle)(screenStart, screenEnd)}rad)`
  };
  let elapsedTimeLeftPosPct = 50;

  /**
   * Calculates a fractional offset from 0 -> 5% as magFactorX decreases from 1 to a min of .5
   */
  if (xScale < 1) {
    const fractionalOffset = 1 / xScale * ((1 - xScale) * 10);
    elapsedTimeLeftPosPct += fractionalOffset;
  }
  return /*#__PURE__*/_react.default.createElement(StyledEdgeLine, {
    className: className,
    style: style,
    resolverEdgeColor: colorMap.resolverEdge,
    magFactorX: xScale,
    "data-test-subj": "resolver:graph:edgeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, elapsedTime && /*#__PURE__*/_react.default.createElement(StyledElapsedTime, {
    backgroundColor: colorMap.resolverEdge,
    leftPct: elapsedTimeLeftPosPct,
    scaledTypeSize: scaledTypeSize,
    textColor: colorMap.resolverEdgeText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.elapsedTime",
    defaultMessage: "{duration} {durationType}",
    values: {
      duration: elapsedTime.duration,
      durationType: elapsedTime.durationType
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })));
});