"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelPanelView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _links = require("../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _link_panel = require("../link_panel");
var _shorten_count_into_string = require("../../../common/utils/shorten_count_into_string");
var _link = require("../link_panel/link");
var _use_ti_data_sources = require("../../containers/overview_cti_links/use_ti_data_sources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/overview_cti_links/threat_intel_panel_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const columns = [{
  name: 'Name',
  field: 'title',
  sortable: true,
  truncateText: true,
  width: '100%'
}, {
  name: 'Indicator',
  field: 'count',
  render: _shorten_count_into_string.shortenCountIntoString,
  sortable: true,
  truncateText: true,
  width: '70px',
  align: 'right'
}, {
  name: '',
  field: 'path',
  truncateText: true,
  width: '80px',
  render: path => /*#__PURE__*/_react.default.createElement(_link.Link, {
    path: path,
    copy: i18n.LINK_COPY,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 31
    }
  })
}];
const ThreatIntelPanelView = ({
  isInspectEnabled = true,
  listItems,
  splitPanel,
  totalCount = 0
}) => {
  return /*#__PURE__*/_react.default.createElement(_link_panel.LinkPanel, {
    columns,
    dataTestSubj: 'cti-dashboard-links',
    inspectQueryId: isInspectEnabled ? _use_ti_data_sources.ID : undefined,
    listItems,
    panelTitle: i18n.PANEL_TITLE,
    splitPanel,
    subtitle: (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "cti-total-event-count",
      defaultMessage: "Showing: {totalCount} {totalCount, plural, one {indicator} other {indicators}}",
      id: "xpack.securitySolution.overview.ctiDashboardSubtitle",
      values: {
        totalCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }), [totalCount]),
    button: (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
      "data-test-subj": "cti-view-indicators",
      deepLinkId: _constants.SecurityPageName.threatIntelligence,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.threatIndicatorsAction",
      defaultMessage: "View indicators",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 15
      }
    })), []),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
};
exports.ThreatIntelPanelView = ThreatIntelPanelView;