"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchLatestScan = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _reactQuery = require("@kbn/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _translations = require("../../translations");
var _kibana = require("../../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchLatestScan = ({
  isPolling,
  endpointId,
  insightTypes,
  onSuccess,
  onInsightGenerationFailure
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const toasts = (0, _kibana.useToasts)();
  return (0, _reactQuery.useQuery)([`fetchOngoingTasks-${endpointId}`, insightTypes.length], async ({
    signal
  }) => {
    try {
      var _response$data;
      const response = await http.get(_elasticAssistantCommon.DEFEND_INSIGHTS, {
        version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
        query: {
          endpoint_ids: [endpointId],
          size: insightTypes.length
        },
        signal
      });
      const timestampStr = (_response$data = response.data[response.data.length - 1]) === null || _response$data === void 0 ? void 0 : _response$data.timestamp;
      const timestamp = timestampStr ? (0, _moment.default)(timestampStr) : null;

      // we only want latest for each type
      const insightsMap = response.data.reduce((acc, curr) => {
        if (!acc[curr.insightType]) {
          acc[curr.insightType] = curr;
        }
        return acc;
      }, {});
      const insights = Object.values(insightsMap);
      const processQueryResults = insightResults => {
        if (!insightResults.length) {
          // no previous scan record - treat as 0 expected insights
          onSuccess(0, null);
          return {
            hasRunning: false
          };
        }
        const expectedCount = insightResults.reduce((total, defendInsight) => total + defendInsight.insights.reduce((acc, insight) => {
          if (!insight.events) return acc;
          return acc + insight.events.length;
        }, 0), 0);
        const hasRunningInsight = insightResults.some(insight => insight.status === _elasticAssistantCommon.DefendInsightStatusEnum.running);
        const hasFailedInsight = insightResults.some(insight => insight.status === _elasticAssistantCommon.DefendInsightStatusEnum.failed);
        if (hasFailedInsight) {
          const failureReasons = insightResults.filter(insight => insight.status === _elasticAssistantCommon.DefendInsightStatusEnum.failed).map(insight => insight.failureReason).filter(Boolean);
          toasts.addDanger({
            title: _translations.WORKFLOW_INSIGHTS.toasts.fetchPendingInsightsError,
            text: failureReasons.join('; ')
          });
          onInsightGenerationFailure();
        }
        if (!hasRunningInsight) {
          onSuccess(expectedCount, timestamp);
        }
        return {
          hasRunning: hasRunningInsight
        };
      };
      return processQueryResults(insights);
    } catch (error) {
      if (error.name !== 'AbortError') {
        var _error$body;
        toasts.addDanger({
          title: _translations.WORKFLOW_INSIGHTS.toasts.fetchPendingInsightsError,
          text: error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.error
        });
      }
      return {
        hasRunning: false
      };
    }
  }, {
    refetchOnWindowFocus: false,
    refetchInterval: isPolling ? 2000 : false
  });
};
exports.useFetchLatestScan = useFetchLatestScan;