"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchExceptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _policy_selector = require("../policy_selector");
var _user_privileges = require("../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/search_exceptions/search_exceptions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GLOBAL_ENTRIES = _i18n.i18n.translate('xpack.securitySolution.management.policiesSelector.globalEntries', {
  defaultMessage: 'Global entries'
});
const UNASSIGNED_ENTRIES = _i18n.i18n.translate('xpack.securitySolution.management.policiesSelector.unassignedEntries', {
  defaultMessage: 'Unassigned entries'
});
const SearchExceptions = exports.SearchExceptions = /*#__PURE__*/(0, _react.memo)(({
  defaultValue = '',
  onSearch,
  placeholder,
  hasPolicyFilter,
  defaultIncludedPolicies = '',
  hideRefreshButton = false
}) => {
  const {
    canCreateArtifactsByPolicy
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const initiallySelectedPolicies = (0, _react.useMemo)(() => {
    return Array.from(new Set(defaultIncludedPolicies.split(',').filter(id => id.trim() !== '')));
  }, [defaultIncludedPolicies]);
  const [query, setQuery] = (0, _react.useState)(defaultValue);
  const [includedPolicies, setIncludedPolicies] = (0, _react.useState)(initiallySelectedPolicies.filter(id => id !== 'global' && id !== 'unassigned'));
  const [additionalSelectionItems, setAdditionalSelectionItems] = (0, _react.useState)([{
    label: _i18n.i18n.translate('xpack.securitySolution.searchExceptions.additionalFiltersGroupLabel', {
      defaultMessage: 'Additional filters'
    }),
    isGroupLabel: true
  }, {
    label: GLOBAL_ENTRIES,
    data: {
      id: 'global'
    },
    checked: initiallySelectedPolicies.includes('global') ? 'on' : undefined,
    'data-test-subj': 'globalOption'
  }, {
    label: UNASSIGNED_ENTRIES,
    data: {
      id: 'unassigned'
    },
    checked: initiallySelectedPolicies.includes('unassigned') ? 'on' : undefined,
    'data-test-subj': 'unassignedOption'
  }]);
  const policySelectionOnChangeHandler = (0, _react.useCallback)((updatedSelectedPolicyIds, updatedAdditionalListItems) => {
    setIncludedPolicies(updatedSelectedPolicyIds);
    const updatedFullSelection = [...updatedSelectedPolicyIds];
    if (updatedAdditionalListItems) {
      for (const additionalItem of updatedAdditionalListItems) {
        if (additionalItem.checked === 'on') {
          var _additionalItem$data;
          updatedFullSelection.push((_additionalItem$data = additionalItem.data) === null || _additionalItem$data === void 0 ? void 0 : _additionalItem$data.id);
        }
      }
      setAdditionalSelectionItems(updatedAdditionalListItems);
    }
    onSearch(query, updatedFullSelection.join(','), false);
  }, [onSearch, query]);
  const handleOnChangeSearchField = (0, _react.useCallback)(ev => setQuery(ev.target.value), [setQuery]);
  const handleOnSearch = (0, _react.useCallback)(() => onSearch(query, includedPolicies.join(), true), [onSearch, query, includedPolicies]);
  const handleOnSearchQuery = (0, _react.useCallback)(value => {
    onSearch(value, includedPolicies.join(), false);
  }, [onSearch, includedPolicies]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "searchExceptions",
    direction: "row",
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    defaultValue: defaultValue,
    placeholder: placeholder,
    onChange: handleOnChangeSearchField,
    onSearch: handleOnSearchQuery,
    isClearable: true,
    fullWidth: true,
    "data-test-subj": "searchField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })), canCreateArtifactsByPolicy && hasPolicyFilter ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_policy_selector.PolicySelectorMenuButton, {
    selectedPolicyIds: includedPolicies,
    additionalListItems: additionalSelectionItems,
    onChange: policySelectionOnChangeHandler,
    "data-test-subj": "policiesSelectorButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  })) : null, !hideRefreshButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    onClick: handleOnSearch,
    "data-test-subj": "searchButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.securitySolution.management.search.button', {
    defaultMessage: 'Refresh'
  }))) : null);
});
SearchExceptions.displayName = 'SearchExceptions';