"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetFileActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _user_privileges = require("../../../../common/components/user_privileges");
var _use_send_get_file_request = require("../../../hooks/response_actions/use_send_get_file_request");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _response_action_file_download_link = require("../../response_action_file_download_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/command_render_components/get_file_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GetFileActionResult = exports.GetFileActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin3;
  const {
    canWriteFileOperations
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const actionCreator = (0, _use_send_get_file_request.useSendGetFileRequest)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$commandDefin, _command$commandDefin2;
    const {
      agentType,
      endpointId
    } = (_command$commandDefin = (_command$commandDefin2 = command.commandDefinition) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.meta) !== null && _command$commandDefin !== void 0 ? _command$commandDefin : {};
    const {
      path,
      comment
    } = command.args.args;
    return endpointId ? {
      agent_type: agentType,
      endpoint_ids: [endpointId],
      comment: comment === null || comment === void 0 ? void 0 : comment[0],
      parameters: {
        path: path[0]
      }
    } : undefined;
  }, [command.args.args, (_command$commandDefin3 = command.commandDefinition) === null || _command$commandDefin3 === void 0 ? void 0 : _command$commandDefin3.meta]);
  const {
    result,
    actionDetails
  } = (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'getFile',
    pendingMessage: _i18n.i18n.translate('xpack.securitySolution.getFileAction.pendingMessage', {
      defaultMessage: 'Retrieving the file from host.'
    })
  });
  if (actionDetails !== null && actionDetails !== void 0 && actionDetails.isCompleted && actionDetails.wasSuccessful) {
    return /*#__PURE__*/_react.default.createElement(ResultComponent, {
      showAs: "success",
      "data-test-subj": "getFileSuccess",
      title: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getFileAction.successTitle', {
        defaultMessage: 'File retrieved from the host.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_response_action_file_download_link.ResponseActionFileDownloadLink, {
      action: actionDetails,
      canAccessFileDownloadLink: canWriteFileOperations,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }));
  }
  return result;
});
GetFileActionResult.displayName = 'GetFileActionResult';