"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserDetailsPanelKey = exports.UserDetailsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_managed_user = require("../shared/hooks/use_managed_user");
var _tabs = require("./tabs");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
var _left_panel_content = require("../shared/components/left_panel/left_panel_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/user_details_left/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UserDetailsPanelKey = exports.UserDetailsPanelKey = 'user_details';
const UserDetailsPanel = ({
  isRiskScoreExist,
  user,
  path,
  scopeId,
  hasMisconfigurationFindings,
  hasNonClosedAlerts
}) => {
  const managedUser = (0, _use_managed_user.useManagedUser)();
  const tabs = (0, _tabs.useTabs)(managedUser.data, user.name, isRiskScoreExist, scopeId, hasMisconfigurationFindings, hasNonClosedAlerts);
  const {
    selectedTabId,
    setSelectedTabId
  } = useSelectedTab(isRiskScoreExist, user, tabs, path, scopeId, hasMisconfigurationFindings, hasNonClosedAlerts);
  if (!selectedTabId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_left_panel_header.LeftPanelHeader, {
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId,
    tabs: tabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_left_panel_content.LeftPanelContent, {
    selectedTabId: selectedTabId,
    tabs: tabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
};
exports.UserDetailsPanel = UserDetailsPanel;
const useSelectedTab = (isRiskScoreExist, user, tabs, path, scopeId, hasMisconfigurationFindings, hasNonClosedAlerts) => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const selectedTabId = (0, _react.useMemo)(() => {
    var _tabs$find$id, _tabs$find;
    const defaultTab = tabs.length > 0 ? tabs[0].id : undefined;
    if (!path) return defaultTab;
    return (_tabs$find$id = (_tabs$find = tabs.find(tab => tab.id === path.tab)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.id) !== null && _tabs$find$id !== void 0 ? _tabs$find$id : defaultTab;
  }, [path, tabs]);
  const setSelectedTabId = tabId => {
    openLeftPanel({
      id: UserDetailsPanelKey,
      params: {
        user,
        isRiskScoreExist,
        hasMisconfigurationFindings,
        hasNonClosedAlerts,
        path: {
          tab: tabId
        },
        scopeId
      }
    });
  };
  return {
    setSelectedTabId,
    selectedTabId
  };
};
UserDetailsPanel.displayName = 'UserDetailsPanel';